package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.CompanyB;
import com.xforceplus.ultramanbocp.service.ICompanyBService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-02-01
 */
@RestController
public class CompanyBController {

  @Autowired
  private ICompanyBService companyBServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param companyB ${table.comment}
   * @return
   */
  @GetMapping("/companybs" )
  public XfR getCompanyBs(XfPage page, CompanyB companyB) {
    return XfR.ok(companyBServiceImpl.page(page, Wrappers.query(companyB)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/companybs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(companyBServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param companyB ${table.comment}
   * @return XfR
   */
  @PostMapping("/companybs")
  public XfR save(@RequestBody CompanyB companyB) {
     return XfR.ok(companyBServiceImpl.save(companyB));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param companyB ${table.comment}
   * @return XfR
   */
  @PutMapping("/companybs/{id}")
  public XfR putUpdate(@RequestBody CompanyB companyB,@PathVariable Long id) {
      companyB.setId(id);
      return XfR.ok(companyBServiceImpl.updateById(companyB));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param companyB ${table.comment}
   * @return XfR
   */
  @PatchMapping("/companybs/{id}")
  public XfR patchUpdate(@RequestBody CompanyB companyB,@PathVariable Long id) {
      CompanyB upcompanyB = companyBServiceImpl.getById(id);
      if(upcompanyB != null){
        upcompanyB = ObjectCopyUtils.copyProperties(companyB,upcompanyB,true);
      }
      return XfR.ok(companyBServiceImpl.updateById(upcompanyB));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/companybs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(companyBServiceImpl.removeById(id));
  }

  @PostMapping("/companybs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "${table.name}");
     params.put("request", condition);

     return XfR.ok(companyBServiceImpl.querys(params));
  }

}
