package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.ExpendBill;
import com.xforceplus.ultramanbocp.service.IExpendBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-02-01
 */
@RestController
public class ExpendBillController {

  @Autowired
  private IExpendBillService expendBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expendBill ${table.comment}
   * @return
   */
  @GetMapping("/expendbills" )
  public XfR getExpendBills(XfPage page, ExpendBill expendBill) {
    return XfR.ok(expendBillServiceImpl.page(page, Wrappers.query(expendBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/expendbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expendBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param expendBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/expendbills")
  public XfR save(@RequestBody ExpendBill expendBill) {
     return XfR.ok(expendBillServiceImpl.save(expendBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param expendBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/expendbills/{id}")
  public XfR putUpdate(@RequestBody ExpendBill expendBill,@PathVariable Long id) {
      expendBill.setId(id);
      return XfR.ok(expendBillServiceImpl.updateById(expendBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param expendBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/expendbills/{id}")
  public XfR patchUpdate(@RequestBody ExpendBill expendBill,@PathVariable Long id) {
      ExpendBill upexpendBill = expendBillServiceImpl.getById(id);
      if(upexpendBill != null){
        upexpendBill = ObjectCopyUtils.copyProperties(expendBill,upexpendBill,true);
      }
      return XfR.ok(expendBillServiceImpl.updateById(upexpendBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expendbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expendBillServiceImpl.removeById(id));
  }

  @PostMapping("/expendbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "expend_bill");
     params.put("request", condition);

     return XfR.ok(expendBillServiceImpl.querys(params));
  }

}
