/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultramanbocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import com.xforceplus.ultraman.bocp.gen.combo.ComboConfig;
import com.xforceplus.ultraman.bocp.gen.combo.ComboOptions;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultramanbocp.entity.Bill;
import com.xforceplus.ultramanbocp.entity.BillDetail;
import com.xforceplus.ultramanbocp.entity.ComboBillDetail;
import com.xforceplus.ultramanbocp.mapper.BillDetailMapper;
import com.xforceplus.ultramanbocp.mapper.BillMapper;
import com.xforceplus.ultramanbocp.service.IBillDetailService;
import com.xforceplus.ultramanbocp.service.IBillService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@BoService(value="1226774612331245570")
@Service
public class BillDetailServiceImpl
extends ServiceImpl<BillDetailMapper, BillDetail>
implements IBillDetailService {
    @Autowired
    IBillService iBillService;
    @Autowired
    BillMapper billMapper;
    private ComboConfig comboConfig;

    @Override
    public IBillDetailService ofOptions(ComboOptions comboOptions) {
        this.comboConfig.changeOptions(comboOptions);
        return this;
    }

    @Override
    public IBillDetailService setLevelLimit(Integer levelLimit) {
        this.comboConfig.changeOptions(new ComboOptions(levelLimit));
        return this;
    }

    private void resetConfig() {
        this.comboConfig.reset();
    }

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest)params.get("request");
        List<Map> result = ((BillDetailMapper)this.baseMapper).querys(params);
        result.stream().forEach(rs -> req.getEntity().getEntities().stream().filter(entity -> rs.containsKey(entity.getCode())).forEach(entity -> {
            HashMap entityRs = (HashMap)rs.get(entity.getCode());
            entityRs.keySet().stream().forEach(key -> rs.put(entity.getCode() + "." + key, entityRs.get(key)));
            rs.remove(entity.getCode());
        }));
        return result;
    }

    @Override
    public IPage<ComboBillDetail> comboPage(IPage<BillDetail> page, Wrapper<BillDetail> queryWrapper) {
        List billDetails = ((BillDetailMapper)this.baseMapper).selectPage(page, queryWrapper).getRecords();
        List billDetailBillIds = billDetails.stream().map(BillDetail::getBillId).collect(Collectors.toList());
        Map<Object, Object> billMap = new HashMap();
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            billMap = this.iBillService.list((Wrapper)Wrappers.lambdaQuery().in(Bill::getId, billDetailBillIds)).stream().collect(Collectors.toMap(Bill::getId, Function.identity()));
        }
        ArrayList<ComboBillDetail> comboBillDetails = new ArrayList<ComboBillDetail>();
        for (BillDetail billDetail : billDetails) {
            ComboBillDetail comboBillDetail = new ComboBillDetail(billDetail);
            if (this.comboConfig.getLevelLimit() >= 2) {
                // empty if block
            }
            if (this.comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(billMap.get(billDetail.getBillId())).ifPresent(bill -> comboBillDetail.setBill(bill));
            }
            comboBillDetails.add(comboBillDetail);
        }
        Page pageResult = new Page();
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(comboBillDetails);
        this.resetConfig();
        return pageResult;
    }

    @Override
    public List<ComboBillDetail> comboList(Wrapper<BillDetail> queryWrapper) {
        List billDetails = ((BillDetailMapper)this.baseMapper).selectList(queryWrapper);
        List billDetailBillIds = billDetails.stream().map(BillDetail::getBillId).collect(Collectors.toList());
        Map<Object, Object> billMap = new HashMap();
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            billMap = this.iBillService.list((Wrapper)Wrappers.lambdaQuery().in(Bill::getId, billDetailBillIds)).stream().collect(Collectors.toMap(Bill::getId, Function.identity()));
        }
        ArrayList<ComboBillDetail> comboBillDetails = new ArrayList<ComboBillDetail>();
        for (BillDetail billDetail : billDetails) {
            ComboBillDetail comboBillDetail = new ComboBillDetail(billDetail);
            if (this.comboConfig.getLevelLimit() >= 2) {
                // empty if block
            }
            if (this.comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(billMap.get(billDetail.getBillId())).ifPresent(bill -> comboBillDetail.setBill(bill));
            }
            comboBillDetails.add(comboBillDetail);
        }
        return comboBillDetails;
    }

    @Override
    public ComboBillDetail comboGetById(Serializable id) {
        BillDetail billDetail = (BillDetail)((BillDetailMapper)this.baseMapper).selectById(id);
        ComboBillDetail comboBillDetail = new ComboBillDetail(billDetail);
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            Bill bill = (Bill)this.iBillService.getById(billDetail.getBillId());
            comboBillDetail.setBill(bill);
        }
        return comboBillDetail;
    }

    @Override
    public boolean comboSave(ComboBillDetail comboEntity) {
        ((BillDetailMapper)this.baseMapper).insert(comboEntity);
        Optional.ofNullable(comboEntity.getBill()).ifPresent(bo -> {
            bo.setId(comboEntity.getBillId());
            this.billMapper.insert(bo);
        });
        return true;
    }

    @Override
    public boolean comboUpdateById(ComboBillDetail comboEntity) {
        ((BillDetailMapper)this.baseMapper).updateById(comboEntity);
        Optional.ofNullable(comboEntity.getBill()).ifPresent(bo -> this.iBillService.updateById(bo));
        return true;
    }

    @Override
    public boolean comboRemoveById(Serializable id) {
        BillDetail billDetail = (BillDetail)((BillDetailMapper)this.baseMapper).selectById(id);
        ((BillDetailMapper)this.baseMapper).deleteById(id);
        Bill bill = (Bill)this.billMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(Bill::getId, (Object)billDetail.getBillId()));
        Optional.ofNullable(bill).ifPresent(bo -> this.billMapper.deleteById(bo.getId()));
        return true;
    }

    @Override
    public BillDetail getByBillId(Long billId) {
        return (BillDetail)((BillDetailMapper)this.baseMapper).selectOne((Wrapper)Wrappers.lambdaQuery().eq(BillDetail::getBillId, (Object)billId));
    }
}

