/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultramanbocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import com.xforceplus.ultraman.bocp.gen.combo.ComboConfig;
import com.xforceplus.ultraman.bocp.gen.combo.ComboOptions;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultramanbocp.entity.Bill;
import com.xforceplus.ultramanbocp.entity.BillDetail;
import com.xforceplus.ultramanbocp.entity.ComboBill;
import com.xforceplus.ultramanbocp.entity.ComboBillDetail;
import com.xforceplus.ultramanbocp.mapper.BillDetailMapper;
import com.xforceplus.ultramanbocp.mapper.BillMapper;
import com.xforceplus.ultramanbocp.service.IBillDetailService;
import com.xforceplus.ultramanbocp.service.IBillService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@BoService(value="1226503190831771649")
@Service
public class BillServiceImpl
extends ServiceImpl<BillMapper, Bill>
implements IBillService {
    @Autowired
    IBillDetailService iBillDetailService;
    @Autowired
    BillDetailMapper billDetailMapper;
    private ComboConfig comboConfig;

    @Override
    public IBillService ofOptions(ComboOptions comboOptions) {
        this.comboConfig.changeOptions(comboOptions);
        return this;
    }

    @Override
    public IBillService setLevelLimit(Integer levelLimit) {
        this.comboConfig.changeOptions(new ComboOptions(levelLimit));
        return this;
    }

    private void resetConfig() {
        this.comboConfig.reset();
    }

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest)params.get("request");
        List<Map> result = ((BillMapper)this.baseMapper).querys(params);
        result.stream().forEach(rs -> req.getEntity().getEntities().stream().filter(entity -> rs.containsKey(entity.getCode())).forEach(entity -> {
            HashMap entityRs = (HashMap)rs.get(entity.getCode());
            entityRs.keySet().stream().forEach(key -> rs.put(entity.getCode() + "." + key, entityRs.get(key)));
            rs.remove(entity.getCode());
        }));
        return result;
    }

    @Override
    public IPage<ComboBill> comboPage(IPage<Bill> page, Wrapper<Bill> queryWrapper) {
        List bills = ((BillMapper)this.baseMapper).selectPage(page, queryWrapper).getRecords();
        List billIds = bills.stream().map(Bill::getId).collect(Collectors.toList());
        Map<Object, Object> comboBillDetailMap = new HashMap();
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            comboBillDetailMap = this.iBillDetailService.setLevelLimit(this.comboConfig.getLevelLimit() - 1).comboList((Wrapper<BillDetail>)((Wrapper)Wrappers.lambdaQuery().in(BillDetail::getBillId, billIds))).stream().collect(Collectors.groupingBy(BillDetail::getBillId));
        }
        ArrayList<ComboBill> comboBills = new ArrayList<ComboBill>();
        for (Bill bill : bills) {
            ComboBill comboBill = new ComboBill(bill);
            if (this.comboConfig.getLevelLimit() >= 2) {
                // empty if block
            }
            if (this.comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(comboBillDetailMap.get(bill.getId())).ifPresent(billDetails -> comboBill.setComboBillDetails(billDetails));
            }
            comboBills.add(comboBill);
        }
        Page pageResult = new Page();
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(comboBills);
        this.resetConfig();
        return pageResult;
    }

    @Override
    public List<ComboBill> comboList(Wrapper<Bill> queryWrapper) {
        List bills = ((BillMapper)this.baseMapper).selectList(queryWrapper);
        List billIds = bills.stream().map(Bill::getId).collect(Collectors.toList());
        Map<Object, Object> comboBillDetailMap = new HashMap();
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            comboBillDetailMap = this.iBillDetailService.setLevelLimit(this.comboConfig.getLevelLimit() - 1).comboList((Wrapper<BillDetail>)((Wrapper)Wrappers.lambdaQuery().in(BillDetail::getBillId, billIds))).stream().collect(Collectors.groupingBy(BillDetail::getBillId));
        }
        ArrayList<ComboBill> comboBills = new ArrayList<ComboBill>();
        for (Bill bill : bills) {
            ComboBill comboBill = new ComboBill(bill);
            if (this.comboConfig.getLevelLimit() >= 2) {
                // empty if block
            }
            if (this.comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(comboBillDetailMap.get(bill.getId())).ifPresent(billDetails -> comboBill.setComboBillDetails(billDetails));
            }
            comboBills.add(comboBill);
        }
        return comboBills;
    }

    @Override
    public ComboBill comboGetById(Serializable id) {
        Bill bill = (Bill)((BillMapper)this.baseMapper).selectById(id);
        ComboBill comboBill = new ComboBill(bill);
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            List<ComboBillDetail> billDetails = this.iBillDetailService.setLevelLimit(this.comboConfig.getLevelLimit() - 1).comboList((Wrapper<BillDetail>)((Wrapper)Wrappers.lambdaQuery().eq(BillDetail::getBillId, (Object)bill.getId())));
            comboBill.setComboBillDetails(billDetails);
        }
        return comboBill;
    }

    @Override
    public boolean comboSave(ComboBill comboEntity) {
        ((BillMapper)this.baseMapper).insert(comboEntity);
        Optional.ofNullable(comboEntity.getComboBillDetails()).ifPresent(billDetails -> billDetails.stream().forEach(bo -> {
            bo.setBillId(comboEntity.getId());
            this.iBillDetailService.comboSave((ComboBillDetail)bo);
        }));
        return true;
    }

    @Override
    public boolean comboUpdateById(ComboBill comboEntity) {
        ((BillMapper)this.baseMapper).updateById(comboEntity);
        Optional.ofNullable(comboEntity.getComboBillDetails()).ifPresent(billDetails -> this.iBillDetailService.updateBatchById(billDetails.stream().map(combo -> combo).collect(Collectors.toList())));
        return true;
    }

    @Override
    public boolean comboRemoveById(Serializable id) {
        Bill bill = (Bill)((BillMapper)this.baseMapper).selectById(id);
        ((BillMapper)this.baseMapper).deleteById(id);
        List billDetails = this.billDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(BillDetail::getBillId, (Object)bill.getId()));
        billDetails.stream().forEach(bo -> this.billDetailMapper.deleteById(bo.getId()));
        return true;
    }
}

