/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultramanbocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import com.xforceplus.ultraman.bocp.gen.combo.ComboConfig;
import com.xforceplus.ultraman.bocp.gen.combo.ComboOptions;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultramanbocp.entity.ComboInvoiceDetail;
import com.xforceplus.ultramanbocp.entity.Invoice;
import com.xforceplus.ultramanbocp.entity.InvoiceDetail;
import com.xforceplus.ultramanbocp.mapper.InvoiceDetailMapper;
import com.xforceplus.ultramanbocp.mapper.InvoiceMapper;
import com.xforceplus.ultramanbocp.service.IInvoiceDetailService;
import com.xforceplus.ultramanbocp.service.IInvoiceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@BoService(value="1226415155557511169")
@Service
public class InvoiceDetailServiceImpl
extends ServiceImpl<InvoiceDetailMapper, InvoiceDetail>
implements IInvoiceDetailService {
    @Autowired
    IInvoiceService iInvoiceService;
    @Autowired
    InvoiceMapper invoiceMapper;
    private ComboConfig comboConfig;

    @Override
    public IInvoiceDetailService ofOptions(ComboOptions comboOptions) {
        this.comboConfig.changeOptions(comboOptions);
        return this;
    }

    @Override
    public IInvoiceDetailService setLevelLimit(Integer levelLimit) {
        this.comboConfig.changeOptions(new ComboOptions(levelLimit));
        return this;
    }

    private void resetConfig() {
        this.comboConfig.reset();
    }

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest)params.get("request");
        List<Map> result = ((InvoiceDetailMapper)this.baseMapper).querys(params);
        result.stream().forEach(rs -> req.getEntity().getEntities().stream().filter(entity -> rs.containsKey(entity.getCode())).forEach(entity -> {
            HashMap entityRs = (HashMap)rs.get(entity.getCode());
            entityRs.keySet().stream().forEach(key -> rs.put(entity.getCode() + "." + key, entityRs.get(key)));
            rs.remove(entity.getCode());
        }));
        return result;
    }

    @Override
    public IPage<ComboInvoiceDetail> comboPage(IPage<InvoiceDetail> page, Wrapper<InvoiceDetail> queryWrapper) {
        List invoiceDetails = ((InvoiceDetailMapper)this.baseMapper).selectPage(page, queryWrapper).getRecords();
        List invoiceDetailInvoiceIds = invoiceDetails.stream().map(InvoiceDetail::getInvoiceId).collect(Collectors.toList());
        Map<Object, Object> invoiceMap = new HashMap();
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            invoiceMap = this.iInvoiceService.list((Wrapper)Wrappers.lambdaQuery().in(Invoice::getId, invoiceDetailInvoiceIds)).stream().collect(Collectors.toMap(Invoice::getId, Function.identity()));
        }
        ArrayList<ComboInvoiceDetail> comboInvoiceDetails = new ArrayList<ComboInvoiceDetail>();
        for (InvoiceDetail invoiceDetail : invoiceDetails) {
            ComboInvoiceDetail comboInvoiceDetail = new ComboInvoiceDetail(invoiceDetail);
            if (this.comboConfig.getLevelLimit() >= 2) {
                // empty if block
            }
            if (this.comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(invoiceMap.get(invoiceDetail.getInvoiceId())).ifPresent(invoice -> comboInvoiceDetail.setInvoice(invoice));
            }
            comboInvoiceDetails.add(comboInvoiceDetail);
        }
        Page pageResult = new Page();
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(comboInvoiceDetails);
        this.resetConfig();
        return pageResult;
    }

    @Override
    public List<ComboInvoiceDetail> comboList(Wrapper<InvoiceDetail> queryWrapper) {
        List invoiceDetails = ((InvoiceDetailMapper)this.baseMapper).selectList(queryWrapper);
        List invoiceDetailInvoiceIds = invoiceDetails.stream().map(InvoiceDetail::getInvoiceId).collect(Collectors.toList());
        Map<Object, Object> invoiceMap = new HashMap();
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            invoiceMap = this.iInvoiceService.list((Wrapper)Wrappers.lambdaQuery().in(Invoice::getId, invoiceDetailInvoiceIds)).stream().collect(Collectors.toMap(Invoice::getId, Function.identity()));
        }
        ArrayList<ComboInvoiceDetail> comboInvoiceDetails = new ArrayList<ComboInvoiceDetail>();
        for (InvoiceDetail invoiceDetail : invoiceDetails) {
            ComboInvoiceDetail comboInvoiceDetail = new ComboInvoiceDetail(invoiceDetail);
            if (this.comboConfig.getLevelLimit() >= 2) {
                // empty if block
            }
            if (this.comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(invoiceMap.get(invoiceDetail.getInvoiceId())).ifPresent(invoice -> comboInvoiceDetail.setInvoice(invoice));
            }
            comboInvoiceDetails.add(comboInvoiceDetail);
        }
        return comboInvoiceDetails;
    }

    @Override
    public ComboInvoiceDetail comboGetById(Serializable id) {
        InvoiceDetail invoiceDetail = (InvoiceDetail)((InvoiceDetailMapper)this.baseMapper).selectById(id);
        ComboInvoiceDetail comboInvoiceDetail = new ComboInvoiceDetail(invoiceDetail);
        if (this.comboConfig.getLevelLimit() >= 2) {
            // empty if block
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            Invoice invoice = (Invoice)this.iInvoiceService.getById(invoiceDetail.getInvoiceId());
            comboInvoiceDetail.setInvoice(invoice);
        }
        return comboInvoiceDetail;
    }

    @Override
    public boolean comboSave(ComboInvoiceDetail comboEntity) {
        ((InvoiceDetailMapper)this.baseMapper).insert(comboEntity);
        Optional.ofNullable(comboEntity.getInvoice()).ifPresent(bo -> {
            bo.setId(comboEntity.getInvoiceId());
            this.invoiceMapper.insert(bo);
        });
        return true;
    }

    @Override
    public boolean comboUpdateById(ComboInvoiceDetail comboEntity) {
        ((InvoiceDetailMapper)this.baseMapper).updateById(comboEntity);
        Optional.ofNullable(comboEntity.getInvoice()).ifPresent(bo -> this.iInvoiceService.updateById(bo));
        return true;
    }

    @Override
    public boolean comboRemoveById(Serializable id) {
        InvoiceDetail invoiceDetail = (InvoiceDetail)((InvoiceDetailMapper)this.baseMapper).selectById(id);
        ((InvoiceDetailMapper)this.baseMapper).deleteById(id);
        Invoice invoice = (Invoice)this.invoiceMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(Invoice::getId, (Object)invoiceDetail.getInvoiceId()));
        Optional.ofNullable(invoice).ifPresent(bo -> this.invoiceMapper.deleteById(bo.getId()));
        return true;
    }

    @Override
    public InvoiceDetail getByInvoiceId(Long invoiceId) {
        return (InvoiceDetail)((InvoiceDetailMapper)this.baseMapper).selectOne((Wrapper)Wrappers.lambdaQuery().eq(InvoiceDetail::getInvoiceId, (Object)invoiceId));
    }
}

