/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultramanbocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import com.xforceplus.ultraman.bocp.gen.combo.ComboConfig;
import com.xforceplus.ultraman.bocp.gen.combo.ComboOptions;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultramanbocp.entity.ComboInvoice;
import com.xforceplus.ultramanbocp.entity.ComboInvoiceDetail;
import com.xforceplus.ultramanbocp.entity.Company;
import com.xforceplus.ultramanbocp.entity.Invoice;
import com.xforceplus.ultramanbocp.entity.InvoiceDetail;
import com.xforceplus.ultramanbocp.mapper.CompanyMapper;
import com.xforceplus.ultramanbocp.mapper.InvoiceDetailMapper;
import com.xforceplus.ultramanbocp.mapper.InvoiceMapper;
import com.xforceplus.ultramanbocp.service.ICompanyService;
import com.xforceplus.ultramanbocp.service.IInvoiceDetailService;
import com.xforceplus.ultramanbocp.service.IInvoiceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@BoService(value="1226413425763627010")
@Service
public class InvoiceServiceImpl
extends ServiceImpl<InvoiceMapper, Invoice>
implements IInvoiceService {
    @Autowired
    IInvoiceDetailService iInvoiceDetailService;
    @Autowired
    InvoiceDetailMapper invoiceDetailMapper;
    @Autowired
    ICompanyService iCompanyService;
    @Autowired
    CompanyMapper companyMapper;
    private ComboConfig comboConfig;

    @Override
    public IInvoiceService ofOptions(ComboOptions comboOptions) {
        this.comboConfig.changeOptions(comboOptions);
        return this;
    }

    @Override
    public IInvoiceService setLevelLimit(Integer levelLimit) {
        this.comboConfig.changeOptions(new ComboOptions(levelLimit));
        return this;
    }

    private void resetConfig() {
        this.comboConfig.reset();
    }

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest)params.get("request");
        List<Map> result = ((InvoiceMapper)this.baseMapper).querys(params);
        result.stream().forEach(rs -> req.getEntity().getEntities().stream().filter(entity -> rs.containsKey(entity.getCode())).forEach(entity -> {
            HashMap entityRs = (HashMap)rs.get(entity.getCode());
            entityRs.keySet().stream().forEach(key -> rs.put(entity.getCode() + "." + key, entityRs.get(key)));
            rs.remove(entity.getCode());
        }));
        return result;
    }

    @Override
    public IPage<ComboInvoice> comboPage(IPage<Invoice> page, Wrapper<Invoice> queryWrapper) {
        List invoices = ((InvoiceMapper)this.baseMapper).selectPage(page, queryWrapper).getRecords();
        List invoiceIds = invoices.stream().map(Invoice::getId).collect(Collectors.toList());
        Map<Object, Object> comboInvoiceDetailMap = new HashMap();
        List invoiceCompanyCodes = invoices.stream().map(Invoice::getCompanyCode).collect(Collectors.toList());
        Map<Object, Object> companyMap = new HashMap();
        if (this.comboConfig.getLevelLimit() >= 2) {
            companyMap = this.companyMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(Company::getCode, invoiceCompanyCodes)).stream().collect(Collectors.toMap(Company::getCode, Function.identity()));
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            comboInvoiceDetailMap = this.iInvoiceDetailService.setLevelLimit(this.comboConfig.getLevelLimit() - 1).comboList((Wrapper<InvoiceDetail>)((Wrapper)Wrappers.lambdaQuery().in(InvoiceDetail::getInvoiceId, invoiceIds))).stream().collect(Collectors.groupingBy(InvoiceDetail::getInvoiceId));
        }
        ArrayList<ComboInvoice> comboInvoices = new ArrayList<ComboInvoice>();
        for (Invoice invoice : invoices) {
            ComboInvoice comboInvoice = new ComboInvoice(invoice);
            if (this.comboConfig.getLevelLimit() >= 2) {
                Optional.ofNullable(companyMap.get(invoice.getCompanyCode())).ifPresent(company -> comboInvoice.setCompany(company));
            }
            if (this.comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(comboInvoiceDetailMap.get(invoice.getId())).ifPresent(invoiceDetails -> comboInvoice.setComboInvoiceDetails(invoiceDetails));
            }
            comboInvoices.add(comboInvoice);
        }
        Page pageResult = new Page();
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(comboInvoices);
        this.resetConfig();
        return pageResult;
    }

    @Override
    public List<ComboInvoice> comboList(Wrapper<Invoice> queryWrapper) {
        List invoices = ((InvoiceMapper)this.baseMapper).selectList(queryWrapper);
        List invoiceIds = invoices.stream().map(Invoice::getId).collect(Collectors.toList());
        Map<Object, Object> comboInvoiceDetailMap = new HashMap();
        List invoiceCompanyCodes = invoices.stream().map(Invoice::getCompanyCode).collect(Collectors.toList());
        Map<Object, Object> companyMap = new HashMap();
        if (this.comboConfig.getLevelLimit() >= 2) {
            companyMap = this.companyMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(Company::getCode, invoiceCompanyCodes)).stream().collect(Collectors.toMap(Company::getCode, Function.identity()));
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            comboInvoiceDetailMap = this.iInvoiceDetailService.setLevelLimit(this.comboConfig.getLevelLimit() - 1).comboList((Wrapper<InvoiceDetail>)((Wrapper)Wrappers.lambdaQuery().in(InvoiceDetail::getInvoiceId, invoiceIds))).stream().collect(Collectors.groupingBy(InvoiceDetail::getInvoiceId));
        }
        ArrayList<ComboInvoice> comboInvoices = new ArrayList<ComboInvoice>();
        for (Invoice invoice : invoices) {
            ComboInvoice comboInvoice = new ComboInvoice(invoice);
            if (this.comboConfig.getLevelLimit() >= 2) {
                Optional.ofNullable(companyMap.get(invoice.getCompanyCode())).ifPresent(company -> comboInvoice.setCompany(company));
            }
            if (this.comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(comboInvoiceDetailMap.get(invoice.getId())).ifPresent(invoiceDetails -> comboInvoice.setComboInvoiceDetails(invoiceDetails));
            }
            comboInvoices.add(comboInvoice);
        }
        return comboInvoices;
    }

    @Override
    public ComboInvoice comboGetById(Serializable id) {
        Invoice invoice = (Invoice)((InvoiceMapper)this.baseMapper).selectById(id);
        ComboInvoice comboInvoice = new ComboInvoice(invoice);
        if (this.comboConfig.getLevelLimit() >= 2) {
            Company company = (Company)this.companyMapper.selectById((Serializable)((Object)invoice.getCompanyCode()));
            comboInvoice.setCompany(company);
        }
        if (this.comboConfig.getLevelLimit() >= 3) {
            List<ComboInvoiceDetail> invoiceDetails = this.iInvoiceDetailService.setLevelLimit(this.comboConfig.getLevelLimit() - 1).comboList((Wrapper<InvoiceDetail>)((Wrapper)Wrappers.lambdaQuery().eq(InvoiceDetail::getInvoiceId, (Object)invoice.getId())));
            comboInvoice.setComboInvoiceDetails(invoiceDetails);
        }
        return comboInvoice;
    }

    @Override
    public boolean comboSave(ComboInvoice comboEntity) {
        ((InvoiceMapper)this.baseMapper).insert(comboEntity);
        Optional.ofNullable(comboEntity.getComboInvoiceDetails()).ifPresent(invoiceDetails -> invoiceDetails.stream().forEach(bo -> {
            bo.setInvoiceId(comboEntity.getId());
            this.iInvoiceDetailService.comboSave((ComboInvoiceDetail)bo);
        }));
        Optional.ofNullable(comboEntity.getCompany()).ifPresent(bo -> {
            bo.setCode(comboEntity.getCompanyCode());
            this.companyMapper.insert(bo);
        });
        return true;
    }

    @Override
    public boolean comboUpdateById(ComboInvoice comboEntity) {
        ((InvoiceMapper)this.baseMapper).updateById(comboEntity);
        Optional.ofNullable(comboEntity.getComboInvoiceDetails()).ifPresent(invoiceDetails -> this.iInvoiceDetailService.updateBatchById(invoiceDetails.stream().map(combo -> combo).collect(Collectors.toList())));
        Optional.ofNullable(comboEntity.getCompany()).ifPresent(bo -> this.companyMapper.updateById(bo));
        return true;
    }

    @Override
    public boolean comboRemoveById(Serializable id) {
        Invoice invoice = (Invoice)((InvoiceMapper)this.baseMapper).selectById(id);
        ((InvoiceMapper)this.baseMapper).deleteById(id);
        List invoiceDetails = this.invoiceDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(InvoiceDetail::getInvoiceId, (Object)invoice.getId()));
        invoiceDetails.stream().forEach(bo -> this.invoiceDetailMapper.deleteById(bo.getId()));
        Company company = (Company)this.companyMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(Company::getCode, (Object)invoice.getCompanyCode()));
        Optional.ofNullable(company).ifPresent(bo -> this.companyMapper.deleteById(bo.getId()));
        return true;
    }
}

