/*
 *    Copyright (c) 2020-2027, wangzheng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the pig4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: wangzheng (wangzheng@xforceplus.com)
 */

package com.xforceplus.ultramanbocp.service.impl;

import com.xforceplus.ultramanbocp.entity.Bill;
import com.xforceplus.ultramanbocp.mapper.BillMapper;
import com.xforceplus.ultramanbocp.service.IBillService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Optional;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.function.Function;

import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xforceplus.ultraman.bocp.gen.combo.ComboConfig;
import com.xforceplus.ultraman.bocp.gen.combo.ComboOptions;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultramanbocp.entity.ComboBill;
import com.xforceplus.ultramanbocp.entity.BillDetail;
import com.xforceplus.ultramanbocp.service.IBillDetailService;
import com.xforceplus.ultramanbocp.mapper.BillDetailMapper;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ultraman
 * @since 2020-12-02
 */
@BoService(value = "1226503190831771649")
@Service
public class BillServiceImpl extends ServiceImpl<BillMapper, Bill> implements IBillService {


    @Autowired
    IBillDetailService billDetailServiceImpl;
    @Autowired
    BillDetailMapper billDetailMapper;

    private ComboConfig comboConfig = new ComboConfig();

    @Override
    public IBillService ofOptions(ComboOptions comboOptions) {
        this.comboConfig.changeOptions(comboOptions);
        return this;
    }

    @Override
    public IBillService setLevelLimit(Integer levelLimit) {
        this.comboConfig.changeOptions(new ComboOptions(levelLimit));
        return this;
    }

    private void resetConfig() {
        this.comboConfig.reset();
    }

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest) params.get("request");
        List<Map> result = this.baseMapper.querys(params);
        result.stream().forEach(rs ->
            req.getEntity().getEntities().stream()
            .filter(entity -> rs.containsKey(entity.getCode()))
            .forEach(entity -> {
                Map entityRs = (HashMap) rs.get(entity.getCode());
                entityRs.keySet().stream().forEach(key ->
                    rs.put(entity.getCode() + "." + key, entityRs.get(key))
                );
                rs.remove(entity.getCode());
            })
        );
        return result;
    }

    @Override
    public IPage<ComboBill> comboPage(IPage<Bill> page, Wrapper<Bill> queryWrapper) {
        List<Bill> bills = baseMapper.selectPage(page, queryWrapper).getRecords();

        List<Long> billIds = bills.stream().map(Bill::getId).collect(Collectors.toList());


        Map<Long, List<BillDetail>> billDetailMap = new HashMap<>();

        if(comboConfig.getLevelLimit() >= 2) {
            billDetailMap = billDetailMapper.selectList(Wrappers.<BillDetail>lambdaQuery().in(BillDetail::getBillId, billIds))
                .stream().collect(Collectors.groupingBy(BillDetail::getBillId));
        }

        if(comboConfig.getLevelLimit() >= 3) {
        }

        List<ComboBill> comboBills = new ArrayList<>();
        for(Bill bill:bills) {
            ComboBill comboBill = new ComboBill(bill);
            if(comboConfig.getLevelLimit() >= 2) {
                Optional.ofNullable(billDetailMap.get(bill.getId())).ifPresent(billDetails -> comboBill.setBillDetails(billDetails));
            }
            if(comboConfig.getLevelLimit() >= 3) {
            }
            comboBills.add(comboBill);
        }

        IPage<ComboBill> pageResult = new Page<>();
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(comboBills);

        this.resetConfig();

        return pageResult;
    }

    @Override
    public List<ComboBill> comboList(Wrapper<Bill> queryWrapper) {
        List<Bill> bills = baseMapper.selectList(queryWrapper);

        List<Long> billIds = bills.stream().map(Bill::getId).collect(Collectors.toList());

        Map<Long, List<BillDetail>> billDetailMap = new HashMap<>();

        if(comboConfig.getLevelLimit() >= 2) {
            billDetailMap = billDetailMapper.selectList(Wrappers.<BillDetail>lambdaQuery().in(BillDetail::getBillId, billIds))
                .stream().collect(Collectors.groupingBy(BillDetail::getBillId));
        }

        if(comboConfig.getLevelLimit() >= 3) {
        }

        List<ComboBill> comboBills = new ArrayList<>();
        for(Bill bill:bills) {
            ComboBill comboBill = new ComboBill(bill);
            if(comboConfig.getLevelLimit() >= 2) {
                Optional.ofNullable(billDetailMap.get(bill.getId())).ifPresent(billDetails -> comboBill.setBillDetails(billDetails));
            }
            if(comboConfig.getLevelLimit() >= 3) {
            }
            comboBills.add(comboBill);
        }
        return comboBills;
    }

    @Override
    public ComboBill comboGetById(Serializable id) {
        Bill bill = baseMapper.selectById(id);
        if(bill == null) {
            return null;
        }

        ComboBill comboBill = new ComboBill(bill);
        if(comboConfig.getLevelLimit() >= 2) {
            List<BillDetail> billDetails = billDetailServiceImpl.list(Wrappers.<BillDetail>lambdaQuery().eq(BillDetail::getBillId, bill.getId()));
            comboBill.setBillDetails(billDetails);
        }

        if(comboConfig.getLevelLimit() >= 3) {
       }

        return comboBill;
    }

    @Override
    public boolean comboSave(ComboBill comboEntity) {
        baseMapper.insert(comboEntity);
        Optional.ofNullable(comboEntity.getBillDetails()).ifPresent(billDetails -> {
            billDetails.stream().forEach(bo -> {
                bo.setBillId(comboEntity.getId());
                billDetailMapper.insert(bo);
            });
        });
        return true;
    }

    @Override
    public boolean comboUpdateById(ComboBill comboEntity) {
        baseMapper.updateById(comboEntity);
        Optional.ofNullable(comboEntity.getBillDetails()).ifPresent(billDetails -> {
            billDetails.stream().forEach(billDetail -> {
                billDetailMapper.updateById(billDetail);
            });
        });
        return true;
    }

    @Override
    public boolean comboRemoveById(Serializable id) {
        Bill bill = baseMapper.selectById(id);
        if(bill == null) { return false; }

        baseMapper.deleteById(id);

        List<BillDetail> billDetails = billDetailMapper.selectList(Wrappers.<BillDetail>lambdaQuery().eq(BillDetail::getBillId, bill.getId()));
        billDetails.stream().forEach(bo -> billDetailMapper.deleteById(bo.getId()));
        return true;
    }

}
