/*
 *    Copyright (c) 2020-2027, wangzheng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the pig4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: wangzheng (wangzheng@xforceplus.com)
 */

package com.xforceplus.ultramanbocp.service.impl;

import com.xforceplus.ultramanbocp.entity.BillDetail;
import com.xforceplus.ultramanbocp.mapper.BillDetailMapper;
import com.xforceplus.ultramanbocp.service.IBillDetailService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Optional;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.function.Function;

import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xforceplus.ultraman.bocp.gen.combo.ComboConfig;
import com.xforceplus.ultraman.bocp.gen.combo.ComboOptions;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultramanbocp.entity.ComboBillDetail;
import com.xforceplus.ultramanbocp.entity.ComboBill;
import com.xforceplus.ultramanbocp.entity.Bill;
import com.xforceplus.ultramanbocp.service.IBillService;
import com.xforceplus.ultramanbocp.mapper.BillMapper;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ultraman
 * @since 2021-01-06
 */
@BoService(value = "1226774612331245570")
@Service
public class BillDetailServiceImpl extends ServiceImpl<BillDetailMapper, BillDetail> implements IBillDetailService {


    @Autowired
    IBillService billServiceImpl;
    @Autowired
    BillMapper billMapper;

    private ComboConfig comboConfig = new ComboConfig();

    @Override
    public IBillDetailService ofOptions(ComboOptions comboOptions) {
        this.comboConfig.changeOptions(comboOptions);
        return this;
    }

    @Override
    public IBillDetailService setLevelLimit(Integer levelLimit) {
        this.comboConfig.changeOptions(new ComboOptions(levelLimit));
        return this;
    }

    private void resetConfig() {
        this.comboConfig.reset();
    }

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest) params.get("request");
        List<Map> result = this.baseMapper.querys(params);
        result.stream().forEach(rs ->
            req.getEntity().getEntities().stream()
            .filter(entity -> rs.containsKey(entity.getCode()))
            .forEach(entity -> {
                Map entityRs = (HashMap) rs.get(entity.getCode());
                entityRs.keySet().stream().forEach(key ->
                    rs.put(entity.getCode() + "." + key, entityRs.get(key))
                );
                rs.remove(entity.getCode());
            })
        );
        return result;
    }

    @Override
    public IPage<ComboBillDetail> comboPage(IPage<BillDetail> page, Wrapper<BillDetail> queryWrapper) {
        List<BillDetail> billDetails = baseMapper.selectPage(page, queryWrapper).getRecords();

        List<Long> billDetailBillIds = billDetails.stream().map(BillDetail::getBillId).collect(Collectors.toList());


        Map<Long, Bill> billMap = new HashMap<>();

        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            billMap = billServiceImpl.list(Wrappers.<Bill>lambdaQuery().in(Bill::getId, billDetailBillIds))
                .stream().collect(Collectors.toMap(Bill::getId, Function.identity()));
        }

        List<ComboBillDetail> comboBillDetails = new ArrayList<>();
        for(BillDetail billDetail:billDetails) {
            ComboBillDetail comboBillDetail = new ComboBillDetail(billDetail);
            if(comboConfig.getLevelLimit() >= 2) {
            }
            if(comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(billMap.get(billDetail.getBillId())).ifPresent(bill -> comboBillDetail.setBill(bill));
            }
            comboBillDetails.add(comboBillDetail);
        }

        IPage<ComboBillDetail> pageResult = new Page<>();
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(comboBillDetails);

        this.resetConfig();

        return pageResult;
    }

    @Override
    public List<ComboBillDetail> comboList(Wrapper<BillDetail> queryWrapper) {
        List<BillDetail> billDetails = baseMapper.selectList(queryWrapper);

        List<Long> billDetailBillIds = billDetails.stream().map(BillDetail::getBillId).collect(Collectors.toList());

        Map<Long, Bill> billMap = new HashMap<>();

        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            billMap = billServiceImpl.list(Wrappers.<Bill>lambdaQuery().in(Bill::getId, billDetailBillIds))
                .stream().collect(Collectors.toMap(Bill::getId, Function.identity()));
        }

        List<ComboBillDetail> comboBillDetails = new ArrayList<>();
        for(BillDetail billDetail:billDetails) {
            ComboBillDetail comboBillDetail = new ComboBillDetail(billDetail);
            if(comboConfig.getLevelLimit() >= 2) {
            }
            if(comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(billMap.get(billDetail.getBillId())).ifPresent(bill -> comboBillDetail.setBill(bill));
            }
            comboBillDetails.add(comboBillDetail);
        }
        return comboBillDetails;
    }

    @Override
    public ComboBillDetail comboGetById(Serializable id) {
        BillDetail billDetail = baseMapper.selectById(id);
        if(billDetail == null) {
            return null;
        }

        ComboBillDetail comboBillDetail = new ComboBillDetail(billDetail);
        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            Bill bill = billServiceImpl.getById(billDetail.getBillId());
            comboBillDetail.setBill(bill);
       }

        return comboBillDetail;
    }

    @Override
    public boolean comboSave(ComboBillDetail comboEntity) {
        baseMapper.insert(comboEntity);
        return true;
    }

    @Override
    public boolean comboUpdateById(ComboBillDetail comboEntity) {
        baseMapper.updateById(comboEntity);
        return true;
    }

    @Override
    public boolean comboRemoveById(Serializable id) {
        BillDetail billDetail = baseMapper.selectById(id);
        if(billDetail == null) { return false; }

        baseMapper.deleteById(id);

        return true;
    }

    @Override
    public List<BillDetail> getByBillId(Long billId) {
        return baseMapper.selectList(Wrappers.<BillDetail>lambdaQuery().eq(BillDetail::getBillId, billId));
    }
}
