/*
 *    Copyright (c) 2020-2027, wangzheng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the pig4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: wangzheng (wangzheng@xforceplus.com)
 */

package com.xforceplus.ultramanbocp.service.impl;

import com.xforceplus.ultramanbocp.entity.InvoiceDetail;
import com.xforceplus.ultramanbocp.mapper.InvoiceDetailMapper;
import com.xforceplus.ultramanbocp.service.IInvoiceDetailService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Optional;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.function.Function;

import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xforceplus.ultraman.bocp.gen.combo.ComboConfig;
import com.xforceplus.ultraman.bocp.gen.combo.ComboOptions;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultramanbocp.entity.ComboInvoiceDetail;
import com.xforceplus.ultramanbocp.entity.ComboInvoice;
import com.xforceplus.ultramanbocp.entity.Invoice;
import com.xforceplus.ultramanbocp.service.IInvoiceService;
import com.xforceplus.ultramanbocp.mapper.InvoiceMapper;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ultraman
 * @since 2021-01-06
 */
@BoService(value = "1226415155557511169")
@Service
public class InvoiceDetailServiceImpl extends ServiceImpl<InvoiceDetailMapper, InvoiceDetail> implements IInvoiceDetailService {


    @Autowired
    IInvoiceService invoiceServiceImpl;
    @Autowired
    InvoiceMapper invoiceMapper;

    private ComboConfig comboConfig = new ComboConfig();

    @Override
    public IInvoiceDetailService ofOptions(ComboOptions comboOptions) {
        this.comboConfig.changeOptions(comboOptions);
        return this;
    }

    @Override
    public IInvoiceDetailService setLevelLimit(Integer levelLimit) {
        this.comboConfig.changeOptions(new ComboOptions(levelLimit));
        return this;
    }

    private void resetConfig() {
        this.comboConfig.reset();
    }

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest) params.get("request");
        List<Map> result = this.baseMapper.querys(params);
        result.stream().forEach(rs ->
            req.getEntity().getEntities().stream()
            .filter(entity -> rs.containsKey(entity.getCode()))
            .forEach(entity -> {
                Map entityRs = (HashMap) rs.get(entity.getCode());
                entityRs.keySet().stream().forEach(key ->
                    rs.put(entity.getCode() + "." + key, entityRs.get(key))
                );
                rs.remove(entity.getCode());
            })
        );
        return result;
    }

    @Override
    public IPage<ComboInvoiceDetail> comboPage(IPage<InvoiceDetail> page, Wrapper<InvoiceDetail> queryWrapper) {
        List<InvoiceDetail> invoiceDetails = baseMapper.selectPage(page, queryWrapper).getRecords();

        List<Long> invoiceDetailIds = invoiceDetails.stream().map(InvoiceDetail::getId).collect(Collectors.toList());


        Map<Long, Invoice> invoiceMap = new HashMap<>();

        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            invoiceMap = invoiceServiceImpl.list(Wrappers.<Invoice>lambdaQuery().in(Invoice::getId, invoiceDetailIds))
                .stream().collect(Collectors.toMap(Invoice::getId, Function.identity()));
        }

        List<ComboInvoiceDetail> comboInvoiceDetails = new ArrayList<>();
        for(InvoiceDetail invoiceDetail:invoiceDetails) {
            ComboInvoiceDetail comboInvoiceDetail = new ComboInvoiceDetail(invoiceDetail);
            if(comboConfig.getLevelLimit() >= 2) {
            }
            if(comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(invoiceMap.get(invoiceDetail.getId())).ifPresent(invoice -> comboInvoiceDetail.setInvoice(invoice));
            }
            comboInvoiceDetails.add(comboInvoiceDetail);
        }

        IPage<ComboInvoiceDetail> pageResult = new Page<>();
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(comboInvoiceDetails);

        this.resetConfig();

        return pageResult;
    }

    @Override
    public List<ComboInvoiceDetail> comboList(Wrapper<InvoiceDetail> queryWrapper) {
        List<InvoiceDetail> invoiceDetails = baseMapper.selectList(queryWrapper);

        List<Long> invoiceDetailIds = invoiceDetails.stream().map(InvoiceDetail::getId).collect(Collectors.toList());

        Map<Long, Invoice> invoiceMap = new HashMap<>();

        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            invoiceMap = invoiceServiceImpl.list(Wrappers.<Invoice>lambdaQuery().in(Invoice::getId, invoiceDetailIds))
                .stream().collect(Collectors.toMap(Invoice::getId, Function.identity()));
        }

        List<ComboInvoiceDetail> comboInvoiceDetails = new ArrayList<>();
        for(InvoiceDetail invoiceDetail:invoiceDetails) {
            ComboInvoiceDetail comboInvoiceDetail = new ComboInvoiceDetail(invoiceDetail);
            if(comboConfig.getLevelLimit() >= 2) {
            }
            if(comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(invoiceMap.get(invoiceDetail.getId())).ifPresent(invoice -> comboInvoiceDetail.setInvoice(invoice));
            }
            comboInvoiceDetails.add(comboInvoiceDetail);
        }
        return comboInvoiceDetails;
    }

    @Override
    public ComboInvoiceDetail comboGetById(Serializable id) {
        InvoiceDetail invoiceDetail = baseMapper.selectById(id);
        if(invoiceDetail == null) {
            return null;
        }

        ComboInvoiceDetail comboInvoiceDetail = new ComboInvoiceDetail(invoiceDetail);
        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            Invoice invoice = invoiceServiceImpl.getById(invoiceDetail.getId());
            comboInvoiceDetail.setInvoice(invoice);
       }

        return comboInvoiceDetail;
    }

    @Override
    public boolean comboSave(ComboInvoiceDetail comboEntity) {
        baseMapper.insert(comboEntity);
        return true;
    }

    @Override
    public boolean comboUpdateById(ComboInvoiceDetail comboEntity) {
        baseMapper.updateById(comboEntity);
        return true;
    }

    @Override
    public boolean comboRemoveById(Serializable id) {
        InvoiceDetail invoiceDetail = baseMapper.selectById(id);
        if(invoiceDetail == null) { return false; }

        baseMapper.deleteById(id);

        return true;
    }

}
