/*
 *    Copyright (c) 2020-2027, wangzheng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the pig4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: wangzheng (wangzheng@xforceplus.com)
 */

package com.xforceplus.ultramanbocp.service.impl;

import com.xforceplus.ultramanbocp.entity.Invoice;
import com.xforceplus.ultramanbocp.mapper.InvoiceMapper;
import com.xforceplus.ultramanbocp.service.IInvoiceService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Optional;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.function.Function;

import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.xforceplus.ultraman.bocp.gen.combo.ComboConfig;
import com.xforceplus.ultraman.bocp.gen.combo.ComboOptions;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultramanbocp.entity.ComboInvoice;
import com.xforceplus.ultramanbocp.entity.ComboInvoiceDetail;
import com.xforceplus.ultramanbocp.entity.InvoiceDetail;
import com.xforceplus.ultramanbocp.service.IInvoiceDetailService;
import com.xforceplus.ultramanbocp.mapper.InvoiceDetailMapper;
import com.xforceplus.ultramanbocp.entity.ComboBill;
import com.xforceplus.ultramanbocp.entity.Bill;
import com.xforceplus.ultramanbocp.service.IBillService;
import com.xforceplus.ultramanbocp.mapper.BillMapper;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ultraman
 * @since 2021-01-06
 */
@BoService(value = "1226413425763627010")
@Service
public class InvoiceServiceImpl extends ServiceImpl<InvoiceMapper, Invoice> implements IInvoiceService {


    @Autowired
    IInvoiceDetailService invoiceDetailServiceImpl;
    @Autowired
    InvoiceDetailMapper invoiceDetailMapper;
    @Autowired
    IBillService billServiceImpl;
    @Autowired
    BillMapper billMapper;

    private ComboConfig comboConfig = new ComboConfig();

    @Override
    public IInvoiceService ofOptions(ComboOptions comboOptions) {
        this.comboConfig.changeOptions(comboOptions);
        return this;
    }

    @Override
    public IInvoiceService setLevelLimit(Integer levelLimit) {
        this.comboConfig.changeOptions(new ComboOptions(levelLimit));
        return this;
    }

    private void resetConfig() {
        this.comboConfig.reset();
    }

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest) params.get("request");
        List<Map> result = this.baseMapper.querys(params);
        result.stream().forEach(rs ->
            req.getEntity().getEntities().stream()
            .filter(entity -> rs.containsKey(entity.getCode()))
            .forEach(entity -> {
                Map entityRs = (HashMap) rs.get(entity.getCode());
                entityRs.keySet().stream().forEach(key ->
                    rs.put(entity.getCode() + "." + key, entityRs.get(key))
                );
                rs.remove(entity.getCode());
            })
        );
        return result;
    }

    @Override
    public IPage<ComboInvoice> comboPage(IPage<Invoice> page, Wrapper<Invoice> queryWrapper) {
        List<Invoice> invoices = baseMapper.selectPage(page, queryWrapper).getRecords();

        List<Long> invoiceIds = invoices.stream().map(Invoice::getId).collect(Collectors.toList());


        Map<Long, List<ComboInvoiceDetail>> comboInvoiceDetailMap = new HashMap<>();

        Map<Long, Bill> billMap = new HashMap<>();

        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            comboInvoiceDetailMap = invoiceDetailServiceImpl.setLevelLimit(comboConfig.getLevelLimit() - 1).comboList(Wrappers.<InvoiceDetail>lambdaQuery().in(InvoiceDetail::getId, invoiceIds))
                .stream().collect(Collectors.groupingBy(ComboInvoiceDetail::getId));
            billMap = billServiceImpl.list(Wrappers.<Bill>lambdaQuery().in(Bill::getId, invoiceIds))
                .stream().collect(Collectors.toMap(Bill::getId, Function.identity()));
        }

        List<ComboInvoice> comboInvoices = new ArrayList<>();
        for(Invoice invoice:invoices) {
            ComboInvoice comboInvoice = new ComboInvoice(invoice);
            if(comboConfig.getLevelLimit() >= 2) {
            }
            if(comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(comboInvoiceDetailMap.get(invoice.getId())).ifPresent(invoiceDetails -> comboInvoice.setComboInvoiceDetails(invoiceDetails));
                Optional.ofNullable(billMap.get(invoice.getId())).ifPresent(bill -> comboInvoice.setBill(bill));
            }
            comboInvoices.add(comboInvoice);
        }

        IPage<ComboInvoice> pageResult = new Page<>();
        pageResult.setTotal(page.getTotal());
        pageResult.setRecords(comboInvoices);

        this.resetConfig();

        return pageResult;
    }

    @Override
    public List<ComboInvoice> comboList(Wrapper<Invoice> queryWrapper) {
        List<Invoice> invoices = baseMapper.selectList(queryWrapper);

        List<Long> invoiceIds = invoices.stream().map(Invoice::getId).collect(Collectors.toList());

        Map<Long, List<ComboInvoiceDetail>> comboInvoiceDetailMap = new HashMap<>();
        Map<Long, Bill> billMap = new HashMap<>();

        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            comboInvoiceDetailMap = invoiceDetailServiceImpl.setLevelLimit(comboConfig.getLevelLimit() - 1).comboList(Wrappers.<InvoiceDetail>lambdaQuery().in(InvoiceDetail::getId, invoiceIds))
                .stream().collect(Collectors.groupingBy(ComboInvoiceDetail::getId));
            billMap = billServiceImpl.list(Wrappers.<Bill>lambdaQuery().in(Bill::getId, invoiceIds))
                .stream().collect(Collectors.toMap(Bill::getId, Function.identity()));
        }

        List<ComboInvoice> comboInvoices = new ArrayList<>();
        for(Invoice invoice:invoices) {
            ComboInvoice comboInvoice = new ComboInvoice(invoice);
            if(comboConfig.getLevelLimit() >= 2) {
            }
            if(comboConfig.getLevelLimit() >= 3) {
                Optional.ofNullable(comboInvoiceDetailMap.get(invoice.getId())).ifPresent(invoiceDetails -> comboInvoice.setComboInvoiceDetails(invoiceDetails));
                Optional.ofNullable(billMap.get(invoice.getId())).ifPresent(bill -> comboInvoice.setBill(bill));
            }
            comboInvoices.add(comboInvoice);
        }
        return comboInvoices;
    }

    @Override
    public ComboInvoice comboGetById(Serializable id) {
        Invoice invoice = baseMapper.selectById(id);
        if(invoice == null) {
            return null;
        }

        ComboInvoice comboInvoice = new ComboInvoice(invoice);
        if(comboConfig.getLevelLimit() >= 2) {
        }

        if(comboConfig.getLevelLimit() >= 3) {
            List<ComboInvoiceDetail> invoiceDetails = invoiceDetailServiceImpl.setLevelLimit(comboConfig.getLevelLimit() - 1).comboList(Wrappers.<InvoiceDetail>lambdaQuery().eq(InvoiceDetail::getId, invoice.getId()));
            comboInvoice.setComboInvoiceDetails(invoiceDetails);
            Bill bill = billServiceImpl.getById(invoice.getId());
            comboInvoice.setBill(bill);
       }

        return comboInvoice;
    }

    @Override
    public boolean comboSave(ComboInvoice comboEntity) {
        baseMapper.insert(comboEntity);
        Optional.ofNullable(comboEntity.getComboInvoiceDetails()).ifPresent(invoiceDetails -> {
            invoiceDetails.stream().forEach(bo -> {
                bo.setId(comboEntity.getId());
                invoiceDetailServiceImpl.comboSave(bo);
            });
        });
        return true;
    }

    @Override
    public boolean comboUpdateById(ComboInvoice comboEntity) {
        baseMapper.updateById(comboEntity);
        Optional.ofNullable(comboEntity.getComboInvoiceDetails()).ifPresent(invoiceDetails -> {
            invoiceDetailServiceImpl.updateBatchById(invoiceDetails.stream().map(combo -> (InvoiceDetail)combo).collect(Collectors.toList()));
        });
        return true;
    }

    @Override
    public boolean comboRemoveById(Serializable id) {
        Invoice invoice = baseMapper.selectById(id);
        if(invoice == null) { return false; }

        baseMapper.deleteById(id);

        List<InvoiceDetail> invoiceDetails = invoiceDetailMapper.selectList(Wrappers.<InvoiceDetail>lambdaQuery().eq(InvoiceDetail::getId, invoice.getId()));
        invoiceDetails.stream().forEach(bo -> invoiceDetailMapper.deleteById(bo.getId()));
        return true;
    }

}
