package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Billtest;
import com.xforceplus.ultramanbocp.service.IBilltestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-18
 */
@RestController
public class BilltestController {

  @Autowired
  private IBilltestService billtestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billtest ${table.comment}
   * @return
   */
  @GetMapping("/billtests" )
  public XfR getBilltests(XfPage page, Billtest billtest) {
    return XfR.ok(billtestServiceImpl.page(page, Wrappers.query(billtest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billtests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billtestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billtest ${table.comment}
   * @return XfR
   */
  @PostMapping("/billtests")
  public XfR save(@RequestBody Billtest billtest) {
     return XfR.ok(billtestServiceImpl.save(billtest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billtest ${table.comment}
   * @return XfR
   */
  @PutMapping("/billtests/{id}")
  public XfR putUpdate(@RequestBody Billtest billtest,@PathVariable Long id) {
      billtest.setId(id);
      return XfR.ok(billtestServiceImpl.updateById(billtest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billtest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billtests/{id}")
  public XfR patchUpdate(@RequestBody Billtest billtest,@PathVariable Long id) {
      Billtest upbilltest = billtestServiceImpl.getById(id);
      if(upbilltest != null){
        upbilltest = ObjectCopyUtils.copyProperties(billtest,upbilltest,true);
      }
      return XfR.ok(billtestServiceImpl.updateById(upbilltest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billtests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billtestServiceImpl.removeById(id));
  }

  @PostMapping("/billtests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billtest");
     params.put("request", condition);

     return XfR.ok(billtestServiceImpl.querys(params));
  }

}
