package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Fsd;
import com.xforceplus.ultramanbocp.service.IFsdService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-18
 */
@RestController
public class FsdController {

  @Autowired
  private IFsdService fsdServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fsd ${table.comment}
   * @return
   */
  @GetMapping("/fsds" )
  public XfR getFsds(XfPage page, Fsd fsd) {
    return XfR.ok(fsdServiceImpl.page(page, Wrappers.query(fsd)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fsds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fsdServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fsd ${table.comment}
   * @return XfR
   */
  @PostMapping("/fsds")
  public XfR save(@RequestBody Fsd fsd) {
     return XfR.ok(fsdServiceImpl.save(fsd));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fsd ${table.comment}
   * @return XfR
   */
  @PutMapping("/fsds/{id}")
  public XfR putUpdate(@RequestBody Fsd fsd,@PathVariable Long id) {
      fsd.setId(id);
      return XfR.ok(fsdServiceImpl.updateById(fsd));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fsd ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fsds/{id}")
  public XfR patchUpdate(@RequestBody Fsd fsd,@PathVariable Long id) {
      Fsd upfsd = fsdServiceImpl.getById(id);
      if(upfsd != null){
        upfsd = ObjectCopyUtils.copyProperties(fsd,upfsd,true);
      }
      return XfR.ok(fsdServiceImpl.updateById(upfsd));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fsds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fsdServiceImpl.removeById(id));
  }

  @PostMapping("/fsds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fsd");
     params.put("request", condition);

     return XfR.ok(fsdServiceImpl.querys(params));
  }

}
