package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.ParentTest;
import com.xforceplus.ultramanbocp.service.IParentTestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-18
 */
@RestController
public class ParentTestController {

  @Autowired
  private IParentTestService parentTestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param parentTest ${table.comment}
   * @return
   */
  @GetMapping("/parenttests" )
  public XfR getParentTests(XfPage page, ParentTest parentTest) {
    return XfR.ok(parentTestServiceImpl.page(page, Wrappers.query(parentTest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/parenttests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(parentTestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param parentTest ${table.comment}
   * @return XfR
   */
  @PostMapping("/parenttests")
  public XfR save(@RequestBody ParentTest parentTest) {
     return XfR.ok(parentTestServiceImpl.save(parentTest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param parentTest ${table.comment}
   * @return XfR
   */
  @PutMapping("/parenttests/{id}")
  public XfR putUpdate(@RequestBody ParentTest parentTest,@PathVariable Long id) {
      parentTest.setId(id);
      return XfR.ok(parentTestServiceImpl.updateById(parentTest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param parentTest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/parenttests/{id}")
  public XfR patchUpdate(@RequestBody ParentTest parentTest,@PathVariable Long id) {
      ParentTest upparentTest = parentTestServiceImpl.getById(id);
      if(upparentTest != null){
        upparentTest = ObjectCopyUtils.copyProperties(parentTest,upparentTest,true);
      }
      return XfR.ok(parentTestServiceImpl.updateById(upparentTest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/parenttests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(parentTestServiceImpl.removeById(id));
  }

  @PostMapping("/parenttests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "parent_test");
     params.put("request", condition);

     return XfR.ok(parentTestServiceImpl.querys(params));
  }

}
