package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.People;
import com.xforceplus.ultramanbocp.service.IPeopleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-18
 */
@RestController
public class PeopleController {

  @Autowired
  private IPeopleService peopleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param people ${table.comment}
   * @return
   */
  @GetMapping("/peoples" )
  public XfR getPeoples(XfPage page, People people) {
    return XfR.ok(peopleServiceImpl.page(page, Wrappers.query(people)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/peoples/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(peopleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param people ${table.comment}
   * @return XfR
   */
  @PostMapping("/peoples")
  public XfR save(@RequestBody People people) {
     return XfR.ok(peopleServiceImpl.save(people));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param people ${table.comment}
   * @return XfR
   */
  @PutMapping("/peoples/{id}")
  public XfR putUpdate(@RequestBody People people,@PathVariable Long id) {
      people.setId(id);
      return XfR.ok(peopleServiceImpl.updateById(people));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param people ${table.comment}
   * @return XfR
   */
  @PatchMapping("/peoples/{id}")
  public XfR patchUpdate(@RequestBody People people,@PathVariable Long id) {
      People uppeople = peopleServiceImpl.getById(id);
      if(uppeople != null){
        uppeople = ObjectCopyUtils.copyProperties(people,uppeople,true);
      }
      return XfR.ok(peopleServiceImpl.updateById(uppeople));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/peoples/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(peopleServiceImpl.removeById(id));
  }

  @PostMapping("/peoples/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "people");
     params.put("request", condition);

     return XfR.ok(peopleServiceImpl.querys(params));
  }

}
