package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Sdf;
import com.xforceplus.ultramanbocp.service.ISdfService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-18
 */
@RestController
public class SdfController {

  @Autowired
  private ISdfService sdfServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sdf ${table.comment}
   * @return
   */
  @GetMapping("/sdfs" )
  public XfR getSdfs(XfPage page, Sdf sdf) {
    return XfR.ok(sdfServiceImpl.page(page, Wrappers.query(sdf)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sdfs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sdfServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sdf ${table.comment}
   * @return XfR
   */
  @PostMapping("/sdfs")
  public XfR save(@RequestBody Sdf sdf) {
     return XfR.ok(sdfServiceImpl.save(sdf));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sdf ${table.comment}
   * @return XfR
   */
  @PutMapping("/sdfs/{id}")
  public XfR putUpdate(@RequestBody Sdf sdf,@PathVariable Long id) {
      sdf.setId(id);
      return XfR.ok(sdfServiceImpl.updateById(sdf));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sdf ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sdfs/{id}")
  public XfR patchUpdate(@RequestBody Sdf sdf,@PathVariable Long id) {
      Sdf upsdf = sdfServiceImpl.getById(id);
      if(upsdf != null){
        upsdf = ObjectCopyUtils.copyProperties(sdf,upsdf,true);
      }
      return XfR.ok(sdfServiceImpl.updateById(upsdf));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sdfs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sdfServiceImpl.removeById(id));
  }

  @PostMapping("/sdfs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sdf");
     params.put("request", condition);

     return XfR.ok(sdfServiceImpl.querys(params));
  }

}
