package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Test2;
import com.xforceplus.ultramanbocp.service.ITest2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-01-18
 */
@RestController
public class Test2Controller {

  @Autowired
  private ITest2Service test2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test2 ${table.comment}
   * @return
   */
  @GetMapping("/test2s" )
  public XfR getTest2s(XfPage page, Test2 test2) {
    return XfR.ok(test2ServiceImpl.page(page, Wrappers.query(test2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test2s")
  public XfR save(@RequestBody Test2 test2) {
     return XfR.ok(test2ServiceImpl.save(test2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test2s/{id}")
  public XfR putUpdate(@RequestBody Test2 test2,@PathVariable Long id) {
      test2.setId(id);
      return XfR.ok(test2ServiceImpl.updateById(test2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test2s/{id}")
  public XfR patchUpdate(@RequestBody Test2 test2,@PathVariable Long id) {
      Test2 uptest2 = test2ServiceImpl.getById(id);
      if(uptest2 != null){
        uptest2 = ObjectCopyUtils.copyProperties(test2,uptest2,true);
      }
      return XfR.ok(test2ServiceImpl.updateById(uptest2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test2ServiceImpl.removeById(id));
  }

  @PostMapping("/test2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test2");
     params.put("request", condition);

     return XfR.ok(test2ServiceImpl.querys(params));
  }

}
