package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.App;
import com.xforceplus.ultramanbocp.service.IAppService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class AppController {

  @Autowired
  private IAppService appServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param app ${table.comment}
   * @return
   */
  @GetMapping("/apps" )
  public XfR getApps(XfPage page, App app) {
    return XfR.ok(appServiceImpl.page(page, Wrappers.query(app)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/apps/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param app ${table.comment}
   * @return XfR
   */
  @PostMapping("/apps")
  public XfR save(@RequestBody App app) {
     return XfR.ok(appServiceImpl.save(app));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param app ${table.comment}
   * @return XfR
   */
  @PutMapping("/apps/{id}")
  public XfR putUpdate(@RequestBody App app,@PathVariable Long id) {
      app.setId(id);
      return XfR.ok(appServiceImpl.updateById(app));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param app ${table.comment}
   * @return XfR
   */
  @PatchMapping("/apps/{id}")
  public XfR patchUpdate(@RequestBody App app,@PathVariable Long id) {
      App upapp = appServiceImpl.getById(id);
      if(upapp != null){
        upapp = ObjectCopyUtils.copyProperties(app,upapp,true);
      }
      return XfR.ok(appServiceImpl.updateById(upapp));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/apps/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appServiceImpl.removeById(id));
  }

  @PostMapping("/apps/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "app");
     params.put("request", condition);

     return XfR.ok(appServiceImpl.querys(params));
  }

}
