package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.AppEnv;
import com.xforceplus.ultramanbocp.service.IAppEnvService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class AppEnvController {

  @Autowired
  private IAppEnvService appEnvServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appEnv ${table.comment}
   * @return
   */
  @GetMapping("/appenvs" )
  public XfR getAppEnvs(XfPage page, AppEnv appEnv) {
    return XfR.ok(appEnvServiceImpl.page(page, Wrappers.query(appEnv)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/appenvs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appEnvServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param appEnv ${table.comment}
   * @return XfR
   */
  @PostMapping("/appenvs")
  public XfR save(@RequestBody AppEnv appEnv) {
     return XfR.ok(appEnvServiceImpl.save(appEnv));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param appEnv ${table.comment}
   * @return XfR
   */
  @PutMapping("/appenvs/{id}")
  public XfR putUpdate(@RequestBody AppEnv appEnv,@PathVariable Long id) {
      appEnv.setId(id);
      return XfR.ok(appEnvServiceImpl.updateById(appEnv));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param appEnv ${table.comment}
   * @return XfR
   */
  @PatchMapping("/appenvs/{id}")
  public XfR patchUpdate(@RequestBody AppEnv appEnv,@PathVariable Long id) {
      AppEnv upappEnv = appEnvServiceImpl.getById(id);
      if(upappEnv != null){
        upappEnv = ObjectCopyUtils.copyProperties(appEnv,upappEnv,true);
      }
      return XfR.ok(appEnvServiceImpl.updateById(upappEnv));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/appenvs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appEnvServiceImpl.removeById(id));
  }

  @PostMapping("/appenvs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "app_env");
     params.put("request", condition);

     return XfR.ok(appEnvServiceImpl.querys(params));
  }

}
