package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.ArticleManage1;
import com.xforceplus.ultramanbocp.service.IArticleManage1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class ArticleManage1Controller {

  @Autowired
  private IArticleManage1Service articleManage1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param articleManage1 ${table.comment}
   * @return
   */
  @GetMapping("/articlemanage1s" )
  public XfR getArticleManage1s(XfPage page, ArticleManage1 articleManage1) {
    return XfR.ok(articleManage1ServiceImpl.page(page, Wrappers.query(articleManage1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/articlemanage1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(articleManage1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param articleManage1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/articlemanage1s")
  public XfR save(@RequestBody ArticleManage1 articleManage1) {
     return XfR.ok(articleManage1ServiceImpl.save(articleManage1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param articleManage1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/articlemanage1s/{id}")
  public XfR putUpdate(@RequestBody ArticleManage1 articleManage1,@PathVariable Long id) {
      articleManage1.setId(id);
      return XfR.ok(articleManage1ServiceImpl.updateById(articleManage1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param articleManage1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/articlemanage1s/{id}")
  public XfR patchUpdate(@RequestBody ArticleManage1 articleManage1,@PathVariable Long id) {
      ArticleManage1 uparticleManage1 = articleManage1ServiceImpl.getById(id);
      if(uparticleManage1 != null){
        uparticleManage1 = ObjectCopyUtils.copyProperties(articleManage1,uparticleManage1,true);
      }
      return XfR.ok(articleManage1ServiceImpl.updateById(uparticleManage1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/articlemanage1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(articleManage1ServiceImpl.removeById(id));
  }

  @PostMapping("/articlemanage1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "article_manage1");
     params.put("request", condition);

     return XfR.ok(articleManage1ServiceImpl.querys(params));
  }

}
