package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Form;
import com.xforceplus.ultramanbocp.service.IFormService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class FormController {

  @Autowired
  private IFormService formServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param form ${table.comment}
   * @return
   */
  @GetMapping("/forms" )
  public XfR getForms(XfPage page, Form form) {
    return XfR.ok(formServiceImpl.page(page, Wrappers.query(form)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/forms/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(formServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param form ${table.comment}
   * @return XfR
   */
  @PostMapping("/forms")
  public XfR save(@RequestBody Form form) {
     return XfR.ok(formServiceImpl.save(form));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param form ${table.comment}
   * @return XfR
   */
  @PutMapping("/forms/{id}")
  public XfR putUpdate(@RequestBody Form form,@PathVariable Long id) {
      form.setId(id);
      return XfR.ok(formServiceImpl.updateById(form));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param form ${table.comment}
   * @return XfR
   */
  @PatchMapping("/forms/{id}")
  public XfR patchUpdate(@RequestBody Form form,@PathVariable Long id) {
      Form upform = formServiceImpl.getById(id);
      if(upform != null){
        upform = ObjectCopyUtils.copyProperties(form,upform,true);
      }
      return XfR.ok(formServiceImpl.updateById(upform));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/forms/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(formServiceImpl.removeById(id));
  }

  @PostMapping("/forms/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "form");
     params.put("request", condition);

     return XfR.ok(formServiceImpl.querys(params));
  }

}
