package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.FormDeploySetting;
import com.xforceplus.ultramanbocp.service.IFormDeploySettingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class FormDeploySettingController {

  @Autowired
  private IFormDeploySettingService formDeploySettingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param formDeploySetting ${table.comment}
   * @return
   */
  @GetMapping("/formdeploysettings" )
  public XfR getFormDeploySettings(XfPage page, FormDeploySetting formDeploySetting) {
    return XfR.ok(formDeploySettingServiceImpl.page(page, Wrappers.query(formDeploySetting)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/formdeploysettings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(formDeploySettingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param formDeploySetting ${table.comment}
   * @return XfR
   */
  @PostMapping("/formdeploysettings")
  public XfR save(@RequestBody FormDeploySetting formDeploySetting) {
     return XfR.ok(formDeploySettingServiceImpl.save(formDeploySetting));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param formDeploySetting ${table.comment}
   * @return XfR
   */
  @PutMapping("/formdeploysettings/{id}")
  public XfR putUpdate(@RequestBody FormDeploySetting formDeploySetting,@PathVariable Long id) {
      formDeploySetting.setId(id);
      return XfR.ok(formDeploySettingServiceImpl.updateById(formDeploySetting));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param formDeploySetting ${table.comment}
   * @return XfR
   */
  @PatchMapping("/formdeploysettings/{id}")
  public XfR patchUpdate(@RequestBody FormDeploySetting formDeploySetting,@PathVariable Long id) {
      FormDeploySetting upformDeploySetting = formDeploySettingServiceImpl.getById(id);
      if(upformDeploySetting != null){
        upformDeploySetting = ObjectCopyUtils.copyProperties(formDeploySetting,upformDeploySetting,true);
      }
      return XfR.ok(formDeploySettingServiceImpl.updateById(upformDeploySetting));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/formdeploysettings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(formDeploySettingServiceImpl.removeById(id));
  }

  @PostMapping("/formdeploysettings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "form_deploy_setting");
     params.put("request", condition);

     return XfR.ok(formDeploySettingServiceImpl.querys(params));
  }

}
