package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Multitest2;
import com.xforceplus.ultramanbocp.service.IMultitest2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class Multitest2Controller {

  @Autowired
  private IMultitest2Service multitest2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param multitest2 ${table.comment}
   * @return
   */
  @GetMapping("/multitest2s" )
  public XfR getMultitest2s(XfPage page, Multitest2 multitest2) {
    return XfR.ok(multitest2ServiceImpl.page(page, Wrappers.query(multitest2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/multitest2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(multitest2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param multitest2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/multitest2s")
  public XfR save(@RequestBody Multitest2 multitest2) {
     return XfR.ok(multitest2ServiceImpl.save(multitest2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param multitest2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/multitest2s/{id}")
  public XfR putUpdate(@RequestBody Multitest2 multitest2,@PathVariable Long id) {
      multitest2.setId(id);
      return XfR.ok(multitest2ServiceImpl.updateById(multitest2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param multitest2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/multitest2s/{id}")
  public XfR patchUpdate(@RequestBody Multitest2 multitest2,@PathVariable Long id) {
      Multitest2 upmultitest2 = multitest2ServiceImpl.getById(id);
      if(upmultitest2 != null){
        upmultitest2 = ObjectCopyUtils.copyProperties(multitest2,upmultitest2,true);
      }
      return XfR.ok(multitest2ServiceImpl.updateById(upmultitest2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/multitest2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(multitest2ServiceImpl.removeById(id));
  }

  @PostMapping("/multitest2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "multitest2");
     params.put("request", condition);

     return XfR.ok(multitest2ServiceImpl.querys(params));
  }

}
