package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Multitest;
import com.xforceplus.ultramanbocp.service.IMultitestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class MultitestController {

  @Autowired
  private IMultitestService multitestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param multitest ${table.comment}
   * @return
   */
  @GetMapping("/multitests" )
  public XfR getMultitests(XfPage page, Multitest multitest) {
    return XfR.ok(multitestServiceImpl.page(page, Wrappers.query(multitest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/multitests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(multitestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param multitest ${table.comment}
   * @return XfR
   */
  @PostMapping("/multitests")
  public XfR save(@RequestBody Multitest multitest) {
     return XfR.ok(multitestServiceImpl.save(multitest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param multitest ${table.comment}
   * @return XfR
   */
  @PutMapping("/multitests/{id}")
  public XfR putUpdate(@RequestBody Multitest multitest,@PathVariable Long id) {
      multitest.setId(id);
      return XfR.ok(multitestServiceImpl.updateById(multitest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param multitest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/multitests/{id}")
  public XfR patchUpdate(@RequestBody Multitest multitest,@PathVariable Long id) {
      Multitest upmultitest = multitestServiceImpl.getById(id);
      if(upmultitest != null){
        upmultitest = ObjectCopyUtils.copyProperties(multitest,upmultitest,true);
      }
      return XfR.ok(multitestServiceImpl.updateById(upmultitest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/multitests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(multitestServiceImpl.removeById(id));
  }

  @PostMapping("/multitests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "multitest");
     params.put("request", condition);

     return XfR.ok(multitestServiceImpl.querys(params));
  }

}
