package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.NodeInfo;
import com.xforceplus.ultramanbocp.service.INodeInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class NodeInfoController {

  @Autowired
  private INodeInfoService nodeInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param nodeInfo ${table.comment}
   * @return
   */
  @GetMapping("/nodeinfos" )
  public XfR getNodeInfos(XfPage page, NodeInfo nodeInfo) {
    return XfR.ok(nodeInfoServiceImpl.page(page, Wrappers.query(nodeInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/nodeinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(nodeInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param nodeInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/nodeinfos")
  public XfR save(@RequestBody NodeInfo nodeInfo) {
     return XfR.ok(nodeInfoServiceImpl.save(nodeInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param nodeInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/nodeinfos/{id}")
  public XfR putUpdate(@RequestBody NodeInfo nodeInfo,@PathVariable Long id) {
      nodeInfo.setId(id);
      return XfR.ok(nodeInfoServiceImpl.updateById(nodeInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param nodeInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/nodeinfos/{id}")
  public XfR patchUpdate(@RequestBody NodeInfo nodeInfo,@PathVariable Long id) {
      NodeInfo upnodeInfo = nodeInfoServiceImpl.getById(id);
      if(upnodeInfo != null){
        upnodeInfo = ObjectCopyUtils.copyProperties(nodeInfo,upnodeInfo,true);
      }
      return XfR.ok(nodeInfoServiceImpl.updateById(upnodeInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/nodeinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(nodeInfoServiceImpl.removeById(id));
  }

  @PostMapping("/nodeinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "node_info");
     params.put("request", condition);

     return XfR.ok(nodeInfoServiceImpl.querys(params));
  }

}
