package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.TaxTestDemo;
import com.xforceplus.ultramanbocp.service.ITaxTestDemoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class TaxTestDemoController {

  @Autowired
  private ITaxTestDemoService taxTestDemoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxTestDemo ${table.comment}
   * @return
   */
  @GetMapping("/taxtestdemos" )
  public XfR getTaxTestDemos(XfPage page, TaxTestDemo taxTestDemo) {
    return XfR.ok(taxTestDemoServiceImpl.page(page, Wrappers.query(taxTestDemo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxtestdemos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxTestDemoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxTestDemo ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxtestdemos")
  public XfR save(@RequestBody TaxTestDemo taxTestDemo) {
     return XfR.ok(taxTestDemoServiceImpl.save(taxTestDemo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxTestDemo ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxtestdemos/{id}")
  public XfR putUpdate(@RequestBody TaxTestDemo taxTestDemo,@PathVariable Long id) {
      taxTestDemo.setId(id);
      return XfR.ok(taxTestDemoServiceImpl.updateById(taxTestDemo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxTestDemo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxtestdemos/{id}")
  public XfR patchUpdate(@RequestBody TaxTestDemo taxTestDemo,@PathVariable Long id) {
      TaxTestDemo uptaxTestDemo = taxTestDemoServiceImpl.getById(id);
      if(uptaxTestDemo != null){
        uptaxTestDemo = ObjectCopyUtils.copyProperties(taxTestDemo,uptaxTestDemo,true);
      }
      return XfR.ok(taxTestDemoServiceImpl.updateById(uptaxTestDemo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxtestdemos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxTestDemoServiceImpl.removeById(id));
  }

  @PostMapping("/taxtestdemos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_test_demo");
     params.put("request", condition);

     return XfR.ok(taxTestDemoServiceImpl.querys(params));
  }

}
