package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Test0928;
import com.xforceplus.ultramanbocp.service.ITest0928Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class Test0928Controller {

  @Autowired
  private ITest0928Service test0928ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0928 ${table.comment}
   * @return
   */
  @GetMapping("/test0928s" )
  public XfR getTest0928s(XfPage page, Test0928 test0928) {
    return XfR.ok(test0928ServiceImpl.page(page, Wrappers.query(test0928)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0928s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0928ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test0928 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test0928s")
  public XfR save(@RequestBody Test0928 test0928) {
     return XfR.ok(test0928ServiceImpl.save(test0928));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test0928 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test0928s/{id}")
  public XfR putUpdate(@RequestBody Test0928 test0928,@PathVariable Long id) {
      test0928.setId(id);
      return XfR.ok(test0928ServiceImpl.updateById(test0928));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test0928 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test0928s/{id}")
  public XfR patchUpdate(@RequestBody Test0928 test0928,@PathVariable Long id) {
      Test0928 uptest0928 = test0928ServiceImpl.getById(id);
      if(uptest0928 != null){
        uptest0928 = ObjectCopyUtils.copyProperties(test0928,uptest0928,true);
      }
      return XfR.ok(test0928ServiceImpl.updateById(uptest0928));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0928s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0928ServiceImpl.removeById(id));
  }

  @PostMapping("/test0928s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0928");
     params.put("request", condition);

     return XfR.ok(test0928ServiceImpl.querys(params));
  }

}
