package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.BillDetail;
import com.xforceplus.ultramanbocp.service.IBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-08
 */
@RestController
public class BillDetailController {

  @Autowired
  private IBillDetailService billDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billDetail ${table.comment}
   * @return
   */
  @GetMapping("/billdetails" )
  public XfR getBillDetails(XfPage page, BillDetail billDetail) {
    return XfR.ok(billDetailServiceImpl.page(page, Wrappers.query(billDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/billdetails")
  public XfR save(@RequestBody BillDetail billDetail) {
     return XfR.ok(billDetailServiceImpl.save(billDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/billdetails/{id}")
  public XfR putUpdate(@RequestBody BillDetail billDetail,@PathVariable Long id) {
      billDetail.setId(id);
      return XfR.ok(billDetailServiceImpl.updateById(billDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billdetails/{id}")
  public XfR patchUpdate(@RequestBody BillDetail billDetail,@PathVariable Long id) {
      BillDetail upbillDetail = billDetailServiceImpl.getById(id);
      if(upbillDetail != null){
        upbillDetail = ObjectCopyUtils.copyProperties(billDetail,upbillDetail,true);
      }
      return XfR.ok(billDetailServiceImpl.updateById(upbillDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billDetailServiceImpl.removeById(id));
  }

  @PostMapping("/billdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_detail");
     params.put("request", condition);

     return XfR.ok(billDetailServiceImpl.querys(params));
  }

}
