package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Synctest;
import com.xforceplus.ultramanbocp.service.ISynctestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-08
 */
@RestController
public class SynctestController {

  @Autowired
  private ISynctestService synctestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param synctest ${table.comment}
   * @return
   */
  @GetMapping("/synctests" )
  public XfR getSynctests(XfPage page, Synctest synctest) {
    return XfR.ok(synctestServiceImpl.page(page, Wrappers.query(synctest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/synctests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(synctestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param synctest ${table.comment}
   * @return XfR
   */
  @PostMapping("/synctests")
  public XfR save(@RequestBody Synctest synctest) {
     return XfR.ok(synctestServiceImpl.save(synctest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param synctest ${table.comment}
   * @return XfR
   */
  @PutMapping("/synctests/{id}")
  public XfR putUpdate(@RequestBody Synctest synctest,@PathVariable Long id) {
      synctest.setId(id);
      return XfR.ok(synctestServiceImpl.updateById(synctest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param synctest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/synctests/{id}")
  public XfR patchUpdate(@RequestBody Synctest synctest,@PathVariable Long id) {
      Synctest upsynctest = synctestServiceImpl.getById(id);
      if(upsynctest != null){
        upsynctest = ObjectCopyUtils.copyProperties(synctest,upsynctest,true);
      }
      return XfR.ok(synctestServiceImpl.updateById(upsynctest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/synctests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(synctestServiceImpl.removeById(id));
  }

  @PostMapping("/synctests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "synctest");
     params.put("request", condition);

     return XfR.ok(synctestServiceImpl.querys(params));
  }

}
