package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Syncvehicle;
import com.xforceplus.ultramanbocp.service.ISyncvehicleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-08
 */
@RestController
public class SyncvehicleController {

  @Autowired
  private ISyncvehicleService syncvehicleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param syncvehicle ${table.comment}
   * @return
   */
  @GetMapping("/syncvehicles" )
  public XfR getSyncvehicles(XfPage page, Syncvehicle syncvehicle) {
    return XfR.ok(syncvehicleServiceImpl.page(page, Wrappers.query(syncvehicle)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/syncvehicles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(syncvehicleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param syncvehicle ${table.comment}
   * @return XfR
   */
  @PostMapping("/syncvehicles")
  public XfR save(@RequestBody Syncvehicle syncvehicle) {
     return XfR.ok(syncvehicleServiceImpl.save(syncvehicle));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param syncvehicle ${table.comment}
   * @return XfR
   */
  @PutMapping("/syncvehicles/{id}")
  public XfR putUpdate(@RequestBody Syncvehicle syncvehicle,@PathVariable Long id) {
      syncvehicle.setId(id);
      return XfR.ok(syncvehicleServiceImpl.updateById(syncvehicle));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param syncvehicle ${table.comment}
   * @return XfR
   */
  @PatchMapping("/syncvehicles/{id}")
  public XfR patchUpdate(@RequestBody Syncvehicle syncvehicle,@PathVariable Long id) {
      Syncvehicle upsyncvehicle = syncvehicleServiceImpl.getById(id);
      if(upsyncvehicle != null){
        upsyncvehicle = ObjectCopyUtils.copyProperties(syncvehicle,upsyncvehicle,true);
      }
      return XfR.ok(syncvehicleServiceImpl.updateById(upsyncvehicle));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/syncvehicles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(syncvehicleServiceImpl.removeById(id));
  }

  @PostMapping("/syncvehicles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "syncvehicle");
     params.put("request", condition);

     return XfR.ok(syncvehicleServiceImpl.querys(params));
  }

}
