package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.VehicleInvoice;
import com.xforceplus.ultramanbocp.service.IVehicleInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-08
 */
@RestController
public class VehicleInvoiceController {

  @Autowired
  private IVehicleInvoiceService vehicleInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param vehicleInvoice ${table.comment}
   * @return
   */
  @GetMapping("/vehicleinvoices" )
  public XfR getVehicleInvoices(XfPage page, VehicleInvoice vehicleInvoice) {
    return XfR.ok(vehicleInvoiceServiceImpl.page(page, Wrappers.query(vehicleInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/vehicleinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(vehicleInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param vehicleInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/vehicleinvoices")
  public XfR save(@RequestBody VehicleInvoice vehicleInvoice) {
     return XfR.ok(vehicleInvoiceServiceImpl.save(vehicleInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param vehicleInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/vehicleinvoices/{id}")
  public XfR putUpdate(@RequestBody VehicleInvoice vehicleInvoice,@PathVariable Long id) {
      vehicleInvoice.setId(id);
      return XfR.ok(vehicleInvoiceServiceImpl.updateById(vehicleInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param vehicleInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/vehicleinvoices/{id}")
  public XfR patchUpdate(@RequestBody VehicleInvoice vehicleInvoice,@PathVariable Long id) {
      VehicleInvoice upvehicleInvoice = vehicleInvoiceServiceImpl.getById(id);
      if(upvehicleInvoice != null){
        upvehicleInvoice = ObjectCopyUtils.copyProperties(vehicleInvoice,upvehicleInvoice,true);
      }
      return XfR.ok(vehicleInvoiceServiceImpl.updateById(upvehicleInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/vehicleinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(vehicleInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/vehicleinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "vehicle_invoice");
     params.put("request", condition);

     return XfR.ok(vehicleInvoiceServiceImpl.querys(params));
  }

}
