package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.ExexexBill;
import com.xforceplus.ultramanbocp.service.IExexexBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class ExexexBillController {

  @Autowired
  private IExexexBillService exexexBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exexexBill ${table.comment}
   * @return
   */
  @GetMapping("/exexexbills" )
  public XfR getExexexBills(XfPage page, ExexexBill exexexBill) {
    return XfR.ok(exexexBillServiceImpl.page(page, Wrappers.query(exexexBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/exexexbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exexexBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param exexexBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/exexexbills")
  public XfR save(@RequestBody ExexexBill exexexBill) {
     return XfR.ok(exexexBillServiceImpl.save(exexexBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param exexexBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/exexexbills/{id}")
  public XfR putUpdate(@RequestBody ExexexBill exexexBill,@PathVariable Long id) {
      exexexBill.setId(id);
      return XfR.ok(exexexBillServiceImpl.updateById(exexexBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param exexexBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/exexexbills/{id}")
  public XfR patchUpdate(@RequestBody ExexexBill exexexBill,@PathVariable Long id) {
      ExexexBill upexexexBill = exexexBillServiceImpl.getById(id);
      if(upexexexBill != null){
        upexexexBill = ObjectCopyUtils.copyProperties(exexexBill,upexexexBill,true);
      }
      return XfR.ok(exexexBillServiceImpl.updateById(upexexexBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exexexbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exexexBillServiceImpl.removeById(id));
  }

  @PostMapping("/exexexbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "exexex_bill");
     params.put("request", condition);

     return XfR.ok(exexexBillServiceImpl.querys(params));
  }

}
