package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula1000;
import com.xforceplus.ultramanbocp.service.ITestformula1000Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula1000Controller {

  @Autowired
  private ITestformula1000Service testformula1000ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula1000 ${table.comment}
   * @return
   */
  @GetMapping("/testformula1000s" )
  public XfR getTestformula1000s(XfPage page, Testformula1000 testformula1000) {
    return XfR.ok(testformula1000ServiceImpl.page(page, Wrappers.query(testformula1000)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula1000s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula1000ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula1000 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula1000s")
  public XfR save(@RequestBody Testformula1000 testformula1000) {
     return XfR.ok(testformula1000ServiceImpl.save(testformula1000));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula1000 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula1000s/{id}")
  public XfR putUpdate(@RequestBody Testformula1000 testformula1000,@PathVariable Long id) {
      testformula1000.setId(id);
      return XfR.ok(testformula1000ServiceImpl.updateById(testformula1000));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula1000 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula1000s/{id}")
  public XfR patchUpdate(@RequestBody Testformula1000 testformula1000,@PathVariable Long id) {
      Testformula1000 uptestformula1000 = testformula1000ServiceImpl.getById(id);
      if(uptestformula1000 != null){
        uptestformula1000 = ObjectCopyUtils.copyProperties(testformula1000,uptestformula1000,true);
      }
      return XfR.ok(testformula1000ServiceImpl.updateById(uptestformula1000));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula1000s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula1000ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula1000s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula1000");
     params.put("request", condition);

     return XfR.ok(testformula1000ServiceImpl.querys(params));
  }

}
