package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula100;
import com.xforceplus.ultramanbocp.service.ITestformula100Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula100Controller {

  @Autowired
  private ITestformula100Service testformula100ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula100 ${table.comment}
   * @return
   */
  @GetMapping("/testformula100s" )
  public XfR getTestformula100s(XfPage page, Testformula100 testformula100) {
    return XfR.ok(testformula100ServiceImpl.page(page, Wrappers.query(testformula100)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula100s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula100ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula100 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula100s")
  public XfR save(@RequestBody Testformula100 testformula100) {
     return XfR.ok(testformula100ServiceImpl.save(testformula100));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula100 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula100s/{id}")
  public XfR putUpdate(@RequestBody Testformula100 testformula100,@PathVariable Long id) {
      testformula100.setId(id);
      return XfR.ok(testformula100ServiceImpl.updateById(testformula100));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula100 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula100s/{id}")
  public XfR patchUpdate(@RequestBody Testformula100 testformula100,@PathVariable Long id) {
      Testformula100 uptestformula100 = testformula100ServiceImpl.getById(id);
      if(uptestformula100 != null){
        uptestformula100 = ObjectCopyUtils.copyProperties(testformula100,uptestformula100,true);
      }
      return XfR.ok(testformula100ServiceImpl.updateById(uptestformula100));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula100s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula100ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula100s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula100");
     params.put("request", condition);

     return XfR.ok(testformula100ServiceImpl.querys(params));
  }

}
