package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula101;
import com.xforceplus.ultramanbocp.service.ITestformula101Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula101Controller {

  @Autowired
  private ITestformula101Service testformula101ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula101 ${table.comment}
   * @return
   */
  @GetMapping("/testformula101s" )
  public XfR getTestformula101s(XfPage page, Testformula101 testformula101) {
    return XfR.ok(testformula101ServiceImpl.page(page, Wrappers.query(testformula101)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula101s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula101ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula101 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula101s")
  public XfR save(@RequestBody Testformula101 testformula101) {
     return XfR.ok(testformula101ServiceImpl.save(testformula101));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula101 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula101s/{id}")
  public XfR putUpdate(@RequestBody Testformula101 testformula101,@PathVariable Long id) {
      testformula101.setId(id);
      return XfR.ok(testformula101ServiceImpl.updateById(testformula101));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula101 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula101s/{id}")
  public XfR patchUpdate(@RequestBody Testformula101 testformula101,@PathVariable Long id) {
      Testformula101 uptestformula101 = testformula101ServiceImpl.getById(id);
      if(uptestformula101 != null){
        uptestformula101 = ObjectCopyUtils.copyProperties(testformula101,uptestformula101,true);
      }
      return XfR.ok(testformula101ServiceImpl.updateById(uptestformula101));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula101s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula101ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula101s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula101");
     params.put("request", condition);

     return XfR.ok(testformula101ServiceImpl.querys(params));
  }

}
