package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula28;
import com.xforceplus.ultramanbocp.service.ITestformula28Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula28Controller {

  @Autowired
  private ITestformula28Service testformula28ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula28 ${table.comment}
   * @return
   */
  @GetMapping("/testformula28s" )
  public XfR getTestformula28s(XfPage page, Testformula28 testformula28) {
    return XfR.ok(testformula28ServiceImpl.page(page, Wrappers.query(testformula28)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula28s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula28ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula28 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula28s")
  public XfR save(@RequestBody Testformula28 testformula28) {
     return XfR.ok(testformula28ServiceImpl.save(testformula28));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula28 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula28s/{id}")
  public XfR putUpdate(@RequestBody Testformula28 testformula28,@PathVariable Long id) {
      testformula28.setId(id);
      return XfR.ok(testformula28ServiceImpl.updateById(testformula28));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula28 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula28s/{id}")
  public XfR patchUpdate(@RequestBody Testformula28 testformula28,@PathVariable Long id) {
      Testformula28 uptestformula28 = testformula28ServiceImpl.getById(id);
      if(uptestformula28 != null){
        uptestformula28 = ObjectCopyUtils.copyProperties(testformula28,uptestformula28,true);
      }
      return XfR.ok(testformula28ServiceImpl.updateById(uptestformula28));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula28s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula28ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula28s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula28");
     params.put("request", condition);

     return XfR.ok(testformula28ServiceImpl.querys(params));
  }

}
