package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula44;
import com.xforceplus.ultramanbocp.service.ITestformula44Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula44Controller {

  @Autowired
  private ITestformula44Service testformula44ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula44 ${table.comment}
   * @return
   */
  @GetMapping("/testformula44s" )
  public XfR getTestformula44s(XfPage page, Testformula44 testformula44) {
    return XfR.ok(testformula44ServiceImpl.page(page, Wrappers.query(testformula44)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula44s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula44ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula44 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula44s")
  public XfR save(@RequestBody Testformula44 testformula44) {
     return XfR.ok(testformula44ServiceImpl.save(testformula44));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula44 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula44s/{id}")
  public XfR putUpdate(@RequestBody Testformula44 testformula44,@PathVariable Long id) {
      testformula44.setId(id);
      return XfR.ok(testformula44ServiceImpl.updateById(testformula44));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula44 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula44s/{id}")
  public XfR patchUpdate(@RequestBody Testformula44 testformula44,@PathVariable Long id) {
      Testformula44 uptestformula44 = testformula44ServiceImpl.getById(id);
      if(uptestformula44 != null){
        uptestformula44 = ObjectCopyUtils.copyProperties(testformula44,uptestformula44,true);
      }
      return XfR.ok(testformula44ServiceImpl.updateById(uptestformula44));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula44s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula44ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula44s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula44");
     params.put("request", condition);

     return XfR.ok(testformula44ServiceImpl.querys(params));
  }

}
