package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula4;
import com.xforceplus.ultramanbocp.service.ITestformula4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula4Controller {

  @Autowired
  private ITestformula4Service testformula4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula4 ${table.comment}
   * @return
   */
  @GetMapping("/testformula4s" )
  public XfR getTestformula4s(XfPage page, Testformula4 testformula4) {
    return XfR.ok(testformula4ServiceImpl.page(page, Wrappers.query(testformula4)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula4ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula4 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula4s")
  public XfR save(@RequestBody Testformula4 testformula4) {
     return XfR.ok(testformula4ServiceImpl.save(testformula4));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula4 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula4s/{id}")
  public XfR putUpdate(@RequestBody Testformula4 testformula4,@PathVariable Long id) {
      testformula4.setId(id);
      return XfR.ok(testformula4ServiceImpl.updateById(testformula4));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula4 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula4s/{id}")
  public XfR patchUpdate(@RequestBody Testformula4 testformula4,@PathVariable Long id) {
      Testformula4 uptestformula4 = testformula4ServiceImpl.getById(id);
      if(uptestformula4 != null){
        uptestformula4 = ObjectCopyUtils.copyProperties(testformula4,uptestformula4,true);
      }
      return XfR.ok(testformula4ServiceImpl.updateById(uptestformula4));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula4ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula4");
     params.put("request", condition);

     return XfR.ok(testformula4ServiceImpl.querys(params));
  }

}
