package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula6;
import com.xforceplus.ultramanbocp.service.ITestformula6Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula6Controller {

  @Autowired
  private ITestformula6Service testformula6ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula6 ${table.comment}
   * @return
   */
  @GetMapping("/testformula6s" )
  public XfR getTestformula6s(XfPage page, Testformula6 testformula6) {
    return XfR.ok(testformula6ServiceImpl.page(page, Wrappers.query(testformula6)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula6s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula6ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula6 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula6s")
  public XfR save(@RequestBody Testformula6 testformula6) {
     return XfR.ok(testformula6ServiceImpl.save(testformula6));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula6 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula6s/{id}")
  public XfR putUpdate(@RequestBody Testformula6 testformula6,@PathVariable Long id) {
      testformula6.setId(id);
      return XfR.ok(testformula6ServiceImpl.updateById(testformula6));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula6 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula6s/{id}")
  public XfR patchUpdate(@RequestBody Testformula6 testformula6,@PathVariable Long id) {
      Testformula6 uptestformula6 = testformula6ServiceImpl.getById(id);
      if(uptestformula6 != null){
        uptestformula6 = ObjectCopyUtils.copyProperties(testformula6,uptestformula6,true);
      }
      return XfR.ok(testformula6ServiceImpl.updateById(uptestformula6));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula6s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula6ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula6s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula6");
     params.put("request", condition);

     return XfR.ok(testformula6ServiceImpl.querys(params));
  }

}
