package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula7;
import com.xforceplus.ultramanbocp.service.ITestformula7Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula7Controller {

  @Autowired
  private ITestformula7Service testformula7ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula7 ${table.comment}
   * @return
   */
  @GetMapping("/testformula7s" )
  public XfR getTestformula7s(XfPage page, Testformula7 testformula7) {
    return XfR.ok(testformula7ServiceImpl.page(page, Wrappers.query(testformula7)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula7s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula7ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula7 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula7s")
  public XfR save(@RequestBody Testformula7 testformula7) {
     return XfR.ok(testformula7ServiceImpl.save(testformula7));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula7 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula7s/{id}")
  public XfR putUpdate(@RequestBody Testformula7 testformula7,@PathVariable Long id) {
      testformula7.setId(id);
      return XfR.ok(testformula7ServiceImpl.updateById(testformula7));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula7 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula7s/{id}")
  public XfR patchUpdate(@RequestBody Testformula7 testformula7,@PathVariable Long id) {
      Testformula7 uptestformula7 = testformula7ServiceImpl.getById(id);
      if(uptestformula7 != null){
        uptestformula7 = ObjectCopyUtils.copyProperties(testformula7,uptestformula7,true);
      }
      return XfR.ok(testformula7ServiceImpl.updateById(uptestformula7));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula7s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula7ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula7s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula7");
     params.put("request", condition);

     return XfR.ok(testformula7ServiceImpl.querys(params));
  }

}
