package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula88;
import com.xforceplus.ultramanbocp.service.ITestformula88Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula88Controller {

  @Autowired
  private ITestformula88Service testformula88ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula88 ${table.comment}
   * @return
   */
  @GetMapping("/testformula88s" )
  public XfR getTestformula88s(XfPage page, Testformula88 testformula88) {
    return XfR.ok(testformula88ServiceImpl.page(page, Wrappers.query(testformula88)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula88s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula88ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula88 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula88s")
  public XfR save(@RequestBody Testformula88 testformula88) {
     return XfR.ok(testformula88ServiceImpl.save(testformula88));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula88 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula88s/{id}")
  public XfR putUpdate(@RequestBody Testformula88 testformula88,@PathVariable Long id) {
      testformula88.setId(id);
      return XfR.ok(testformula88ServiceImpl.updateById(testformula88));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula88 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula88s/{id}")
  public XfR patchUpdate(@RequestBody Testformula88 testformula88,@PathVariable Long id) {
      Testformula88 uptestformula88 = testformula88ServiceImpl.getById(id);
      if(uptestformula88 != null){
        uptestformula88 = ObjectCopyUtils.copyProperties(testformula88,uptestformula88,true);
      }
      return XfR.ok(testformula88ServiceImpl.updateById(uptestformula88));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula88s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula88ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula88s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula88");
     params.put("request", condition);

     return XfR.ok(testformula88ServiceImpl.querys(params));
  }

}
