package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula8;
import com.xforceplus.ultramanbocp.service.ITestformula8Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class Testformula8Controller {

  @Autowired
  private ITestformula8Service testformula8ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula8 ${table.comment}
   * @return
   */
  @GetMapping("/testformula8s" )
  public XfR getTestformula8s(XfPage page, Testformula8 testformula8) {
    return XfR.ok(testformula8ServiceImpl.page(page, Wrappers.query(testformula8)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformula8s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformula8ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula8 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformula8s")
  public XfR save(@RequestBody Testformula8 testformula8) {
     return XfR.ok(testformula8ServiceImpl.save(testformula8));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula8 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformula8s/{id}")
  public XfR putUpdate(@RequestBody Testformula8 testformula8,@PathVariable Long id) {
      testformula8.setId(id);
      return XfR.ok(testformula8ServiceImpl.updateById(testformula8));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula8 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformula8s/{id}")
  public XfR patchUpdate(@RequestBody Testformula8 testformula8,@PathVariable Long id) {
      Testformula8 uptestformula8 = testformula8ServiceImpl.getById(id);
      if(uptestformula8 != null){
        uptestformula8 = ObjectCopyUtils.copyProperties(testformula8,uptestformula8,true);
      }
      return XfR.ok(testformula8ServiceImpl.updateById(uptestformula8));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformula8s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformula8ServiceImpl.removeById(id));
  }

  @PostMapping("/testformula8s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula8");
     params.put("request", condition);

     return XfR.ok(testformula8ServiceImpl.querys(params));
  }

}
