package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testformula;
import com.xforceplus.ultramanbocp.service.ITestformulaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-17
 */
@RestController
public class TestformulaController {

  @Autowired
  private ITestformulaService testformulaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testformula ${table.comment}
   * @return
   */
  @GetMapping("/testformulas" )
  public XfR getTestformulas(XfPage page, Testformula testformula) {
    return XfR.ok(testformulaServiceImpl.page(page, Wrappers.query(testformula)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testformulas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testformulaServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testformula ${table.comment}
   * @return XfR
   */
  @PostMapping("/testformulas")
  public XfR save(@RequestBody Testformula testformula) {
     return XfR.ok(testformulaServiceImpl.save(testformula));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testformula ${table.comment}
   * @return XfR
   */
  @PutMapping("/testformulas/{id}")
  public XfR putUpdate(@RequestBody Testformula testformula,@PathVariable Long id) {
      testformula.setId(id);
      return XfR.ok(testformulaServiceImpl.updateById(testformula));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testformula ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testformulas/{id}")
  public XfR patchUpdate(@RequestBody Testformula testformula,@PathVariable Long id) {
      Testformula uptestformula = testformulaServiceImpl.getById(id);
      if(uptestformula != null){
        uptestformula = ObjectCopyUtils.copyProperties(testformula,uptestformula,true);
      }
      return XfR.ok(testformulaServiceImpl.updateById(uptestformula));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testformulas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testformulaServiceImpl.removeById(id));
  }

  @PostMapping("/testformulas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testformula");
     params.put("request", condition);

     return XfR.ok(testformulaServiceImpl.querys(params));
  }

}
