package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.ExInvoice;
import com.xforceplus.ultramanbocp.service.IExInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-23
 */
@RestController
public class ExInvoiceController {

  @Autowired
  private IExInvoiceService exInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exInvoice ${table.comment}
   * @return
   */
  @GetMapping("/exinvoices" )
  public XfR getExInvoices(XfPage page, ExInvoice exInvoice) {
    return XfR.ok(exInvoiceServiceImpl.page(page, Wrappers.query(exInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/exinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param exInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/exinvoices")
  public XfR save(@RequestBody ExInvoice exInvoice) {
     return XfR.ok(exInvoiceServiceImpl.save(exInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param exInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/exinvoices/{id}")
  public XfR putUpdate(@RequestBody ExInvoice exInvoice,@PathVariable Long id) {
      exInvoice.setId(id);
      return XfR.ok(exInvoiceServiceImpl.updateById(exInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param exInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/exinvoices/{id}")
  public XfR patchUpdate(@RequestBody ExInvoice exInvoice,@PathVariable Long id) {
      ExInvoice upexInvoice = exInvoiceServiceImpl.getById(id);
      if(upexInvoice != null){
        upexInvoice = ObjectCopyUtils.copyProperties(exInvoice,upexInvoice,true);
      }
      return XfR.ok(exInvoiceServiceImpl.updateById(upexInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/exinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ex_invoice");
     params.put("request", condition);

     return XfR.ok(exInvoiceServiceImpl.querys(params));
  }

}
