package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.ExexBill;
import com.xforceplus.ultramanbocp.service.IExexBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-27
 */
@RestController
public class ExexBillController {

  @Autowired
  private IExexBillService exexBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exexBill ${table.comment}
   * @return
   */
  @GetMapping("/exexbills" )
  public XfR getExexBills(XfPage page, ExexBill exexBill) {
    return XfR.ok(exexBillServiceImpl.page(page, Wrappers.query(exexBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/exexbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exexBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param exexBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/exexbills")
  public XfR save(@RequestBody ExexBill exexBill) {
     return XfR.ok(exexBillServiceImpl.save(exexBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param exexBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/exexbills/{id}")
  public XfR putUpdate(@RequestBody ExexBill exexBill,@PathVariable Long id) {
      exexBill.setId(id);
      return XfR.ok(exexBillServiceImpl.updateById(exexBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param exexBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/exexbills/{id}")
  public XfR patchUpdate(@RequestBody ExexBill exexBill,@PathVariable Long id) {
      ExexBill upexexBill = exexBillServiceImpl.getById(id);
      if(upexexBill != null){
        upexexBill = ObjectCopyUtils.copyProperties(exexBill,upexexBill,true);
      }
      return XfR.ok(exexBillServiceImpl.updateById(upexexBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exexbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exexBillServiceImpl.removeById(id));
  }

  @PostMapping("/exexbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "exex_bill");
     params.put("request", condition);

     return XfR.ok(exexBillServiceImpl.querys(params));
  }

}
