package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Feijipiao;
import com.xforceplus.ultramanbocp.service.IFeijipiaoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-27
 */
@RestController
public class FeijipiaoController {

  @Autowired
  private IFeijipiaoService feijipiaoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param feijipiao ${table.comment}
   * @return
   */
  @GetMapping("/feijipiaos" )
  public XfR getFeijipiaos(XfPage page, Feijipiao feijipiao) {
    return XfR.ok(feijipiaoServiceImpl.page(page, Wrappers.query(feijipiao)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/feijipiaos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(feijipiaoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param feijipiao ${table.comment}
   * @return XfR
   */
  @PostMapping("/feijipiaos")
  public XfR save(@RequestBody Feijipiao feijipiao) {
     return XfR.ok(feijipiaoServiceImpl.save(feijipiao));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param feijipiao ${table.comment}
   * @return XfR
   */
  @PutMapping("/feijipiaos/{id}")
  public XfR putUpdate(@RequestBody Feijipiao feijipiao,@PathVariable Long id) {
      feijipiao.setId(id);
      return XfR.ok(feijipiaoServiceImpl.updateById(feijipiao));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param feijipiao ${table.comment}
   * @return XfR
   */
  @PatchMapping("/feijipiaos/{id}")
  public XfR patchUpdate(@RequestBody Feijipiao feijipiao,@PathVariable Long id) {
      Feijipiao upfeijipiao = feijipiaoServiceImpl.getById(id);
      if(upfeijipiao != null){
        upfeijipiao = ObjectCopyUtils.copyProperties(feijipiao,upfeijipiao,true);
      }
      return XfR.ok(feijipiaoServiceImpl.updateById(upfeijipiao));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/feijipiaos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(feijipiaoServiceImpl.removeById(id));
  }

  @PostMapping("/feijipiaos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "feijipiao");
     params.put("request", condition);

     return XfR.ok(feijipiaoServiceImpl.querys(params));
  }

}
