package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.ExexexexBill;
import com.xforceplus.ultramanbocp.service.IExexexexBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-23
 */
@RestController
public class ExexexexBillController {

  @Autowired
  private IExexexexBillService exexexexBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exexexexBill ${table.comment}
   * @return
   */
  @GetMapping("/exexexexbills" )
  public XfR getExexexexBills(XfPage page, ExexexexBill exexexexBill) {
    return XfR.ok(exexexexBillServiceImpl.page(page, Wrappers.query(exexexexBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/exexexexbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exexexexBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param exexexexBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/exexexexbills")
  public XfR save(@RequestBody ExexexexBill exexexexBill) {
     return XfR.ok(exexexexBillServiceImpl.save(exexexexBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param exexexexBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/exexexexbills/{id}")
  public XfR putUpdate(@RequestBody ExexexexBill exexexexBill,@PathVariable Long id) {
      exexexexBill.setId(id);
      return XfR.ok(exexexexBillServiceImpl.updateById(exexexexBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param exexexexBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/exexexexbills/{id}")
  public XfR patchUpdate(@RequestBody ExexexexBill exexexexBill,@PathVariable Long id) {
      ExexexexBill upexexexexBill = exexexexBillServiceImpl.getById(id);
      if(upexexexexBill != null){
        upexexexexBill = ObjectCopyUtils.copyProperties(exexexexBill,upexexexexBill,true);
      }
      return XfR.ok(exexexexBillServiceImpl.updateById(upexexexexBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exexexexbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exexexexBillServiceImpl.removeById(id));
  }

  @PostMapping("/exexexexbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "exexexex_bill");
     params.put("request", condition);

     return XfR.ok(exexexexBillServiceImpl.querys(params));
  }

}
