package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.Testmobile;
import com.xforceplus.ultramanbocp.service.ITestmobileService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-23
 */
@RestController
public class TestmobileController {

  @Autowired
  private ITestmobileService testmobileServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testmobile ${table.comment}
   * @return
   */
  @GetMapping("/testmobiles" )
  public XfR getTestmobiles(XfPage page, Testmobile testmobile) {
    return XfR.ok(testmobileServiceImpl.page(page, Wrappers.query(testmobile)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testmobiles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testmobileServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testmobile ${table.comment}
   * @return XfR
   */
  @PostMapping("/testmobiles")
  public XfR save(@RequestBody Testmobile testmobile) {
     return XfR.ok(testmobileServiceImpl.save(testmobile));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testmobile ${table.comment}
   * @return XfR
   */
  @PutMapping("/testmobiles/{id}")
  public XfR putUpdate(@RequestBody Testmobile testmobile,@PathVariable Long id) {
      testmobile.setId(id);
      return XfR.ok(testmobileServiceImpl.updateById(testmobile));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testmobile ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testmobiles/{id}")
  public XfR patchUpdate(@RequestBody Testmobile testmobile,@PathVariable Long id) {
      Testmobile uptestmobile = testmobileServiceImpl.getById(id);
      if(uptestmobile != null){
        uptestmobile = ObjectCopyUtils.copyProperties(testmobile,uptestmobile,true);
      }
      return XfR.ok(testmobileServiceImpl.updateById(uptestmobile));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testmobiles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testmobileServiceImpl.removeById(id));
  }

  @PostMapping("/testmobiles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testmobile");
     params.put("request", condition);

     return XfR.ok(testmobileServiceImpl.querys(params));
  }

}
