package com.xforceplus.ultramandataauth.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-07-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramandataauth.entity.DataAuthPageEntity;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-data-auth")
public interface DataAuthPageEntityFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/dataAuthPageEntity/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param dataAuthPageEntity ${table.comment}
   * @return R
   */
  @PostMapping("/dataAuthPageEntity/add")
  public R save(@RequestBody DataAuthPageEntity dataAuthPageEntity);

  /**
   * 修改${table.comment}
   * @param dataAuthPageEntity ${table.comment}
   * @return R
   */
  @PostMapping("/dataAuthPageEntity/update")
  public R updateById(@RequestBody DataAuthPageEntity dataAuthPageEntity);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/dataAuthPageEntity/del/{id}" )
  public R removeById(@PathVariable Long id);

}