package com.xforceplus.ultramandataauth.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-07-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramandataauth.entity.DataAuthRole;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-data-auth")
public interface DataAuthRoleFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/dataAuthRole/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param dataAuthRole ${table.comment}
   * @return R
   */
  @PostMapping("/dataAuthRole/add")
  public R save(@RequestBody DataAuthRole dataAuthRole);

  /**
   * 修改${table.comment}
   * @param dataAuthRole ${table.comment}
   * @return R
   */
  @PostMapping("/dataAuthRole/update")
  public R updateById(@RequestBody DataAuthRole dataAuthRole);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/dataAuthRole/del/{id}" )
  public R removeById(@PathVariable Long id);

}