package com.xforceplus.ultramanflows.controller;


/**
 * 自动化流历史feign客户端
 *
 * @author ultraman
 * @date 2023-12-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultramanflows.entity.AutomaticFlowHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-flows")
public interface AutomaticFlowHistoryFeignApi {

  /**
   * 通过id查询自动化流历史
   * @param  id
   * @return R
   */
  @GetMapping("/automaticFlowHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增自动化流历史
   * @param automaticFlowHistory 自动化流历史
   * @return R
   */
  @PostMapping("/automaticFlowHistory/add")
  public R save(@RequestBody AutomaticFlowHistory automaticFlowHistory);

  /**
   * 修改自动化流历史
   * @param automaticFlowHistory 自动化流历史
   * @return R
   */
  @PostMapping("/automaticFlowHistory/update")
  public R updateById(@RequestBody AutomaticFlowHistory automaticFlowHistory);

  /**
   * 通过id删除自动化流历史
   * @param  id
   * @return R
   */
  @DeleteMapping("/automaticFlowHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}